<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubGroup StructType
 * @subpackage Structs
 */
class SubGroup extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicleResult
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicleResult
     */
    public $Trailers;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierPerson
     */
    public $Drivers;
    /**
     * Constructor method for SubGroup
     * @uses SubGroup::setDescription()
     * @uses SubGroup::setCode()
     * @uses SubGroup::setVehicles()
     * @uses SubGroup::setTrailers()
     * @uses SubGroup::setDrivers()
     * @param string $description
     * @param string $code
     * @param \ArrayType\ArrayOfIdentifierVehicleResult $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicleResult $trailers
     * @param \ArrayType\ArrayOfIdentifierPerson $drivers
     */
    public function __construct($description = null, $code = null, \ArrayType\ArrayOfIdentifierVehicleResult $vehicles = null, \ArrayType\ArrayOfIdentifierVehicleResult $trailers = null, \ArrayType\ArrayOfIdentifierPerson $drivers = null)
    {
        $this
            ->setDescription($description)
            ->setCode($code)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setDrivers($drivers);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SubGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SubGroup
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicleResult|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicleResult $vehicles
     * @return \StructType\SubGroup
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicleResult $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicleResult|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicleResult $trailers
     * @return \StructType\SubGroup
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicleResult $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifierPerson|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifierPerson $drivers
     * @return \StructType\SubGroup
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifierPerson $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
