<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSmsCommunicationConfig StructType
 * @subpackage Structs
 */
class SetSmsCommunicationConfig extends AbstractStructBase
{
    /**
     * The DurationInMin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DurationInMin;
    /**
     * The IntervalInMin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IntervalInMin;
    /**
     * The IncludeDoorlockInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeDoorlockInfo;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Trailer;
    /**
     * Constructor method for SetSmsCommunicationConfig
     * @uses SetSmsCommunicationConfig::setDurationInMin()
     * @uses SetSmsCommunicationConfig::setIntervalInMin()
     * @uses SetSmsCommunicationConfig::setIncludeDoorlockInfo()
     * @uses SetSmsCommunicationConfig::setVehicle()
     * @uses SetSmsCommunicationConfig::setTrailer()
     * @param int $durationInMin
     * @param int $intervalInMin
     * @param bool $includeDoorlockInfo
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\IdentifierVehicle $trailer
     */
    public function __construct($durationInMin = null, $intervalInMin = null, $includeDoorlockInfo = null, \StructType\IdentifierVehicle $vehicle = null, \StructType\IdentifierVehicle $trailer = null)
    {
        $this
            ->setDurationInMin($durationInMin)
            ->setIntervalInMin($intervalInMin)
            ->setIncludeDoorlockInfo($includeDoorlockInfo)
            ->setVehicle($vehicle)
            ->setTrailer($trailer);
    }
    /**
     * Get DurationInMin value
     * @return int
     */
    public function getDurationInMin()
    {
        return $this->DurationInMin;
    }
    /**
     * Set DurationInMin value
     * @param int $durationInMin
     * @return \StructType\SetSmsCommunicationConfig
     */
    public function setDurationInMin($durationInMin = null)
    {
        // validation for constraint: int
        if (!is_null($durationInMin) && !is_numeric($durationInMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($durationInMin)), __LINE__);
        }
        $this->DurationInMin = $durationInMin;
        return $this;
    }
    /**
     * Get IntervalInMin value
     * @return int
     */
    public function getIntervalInMin()
    {
        return $this->IntervalInMin;
    }
    /**
     * Set IntervalInMin value
     * @param int $intervalInMin
     * @return \StructType\SetSmsCommunicationConfig
     */
    public function setIntervalInMin($intervalInMin = null)
    {
        // validation for constraint: int
        if (!is_null($intervalInMin) && !is_numeric($intervalInMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($intervalInMin)), __LINE__);
        }
        $this->IntervalInMin = $intervalInMin;
        return $this;
    }
    /**
     * Get IncludeDoorlockInfo value
     * @return bool
     */
    public function getIncludeDoorlockInfo()
    {
        return $this->IncludeDoorlockInfo;
    }
    /**
     * Set IncludeDoorlockInfo value
     * @param bool $includeDoorlockInfo
     * @return \StructType\SetSmsCommunicationConfig
     */
    public function setIncludeDoorlockInfo($includeDoorlockInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDoorlockInfo) && !is_bool($includeDoorlockInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeDoorlockInfo)), __LINE__);
        }
        $this->IncludeDoorlockInfo = $includeDoorlockInfo;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\SetSmsCommunicationConfig
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicle $trailer
     * @return \StructType\SetSmsCommunicationConfig
     */
    public function setTrailer(\StructType\IdentifierVehicle $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetSmsCommunicationConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
