<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceTimesSelection_V4 StructType
 * @subpackage Structs
 */
class ServiceTimesSelection_V4 extends ServiceTimesSelection_V3
{
    /**
     * The DataKind
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DataKind;
    /**
     * The IncludeInactiveData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeInactiveData;
    /**
     * Constructor method for ServiceTimesSelection_V4
     * @uses ServiceTimesSelection_V4::setDataKind()
     * @uses ServiceTimesSelection_V4::setIncludeInactiveData()
     * @param string $dataKind
     * @param bool $includeInactiveData
     */
    public function __construct($dataKind = null, $includeInactiveData = null)
    {
        $this
            ->setDataKind($dataKind)
            ->setIncludeInactiveData($includeInactiveData);
    }
    /**
     * Get DataKind value
     * @return string
     */
    public function getDataKind()
    {
        return $this->DataKind;
    }
    /**
     * Set DataKind value
     * @uses \EnumType\EnumDataKind::valueIsValid()
     * @uses \EnumType\EnumDataKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataKind
     * @return \StructType\ServiceTimesSelection_V4
     */
    public function setDataKind($dataKind = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumDataKind::valueIsValid($dataKind)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataKind, implode(', ', \EnumType\EnumDataKind::getValidValues())), __LINE__);
        }
        $this->DataKind = $dataKind;
        return $this;
    }
    /**
     * Get IncludeInactiveData value
     * @return bool
     */
    public function getIncludeInactiveData()
    {
        return $this->IncludeInactiveData;
    }
    /**
     * Set IncludeInactiveData value
     * @param bool $includeInactiveData
     * @return \StructType\ServiceTimesSelection_V4
     */
    public function setIncludeInactiveData($includeInactiveData = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInactiveData) && !is_bool($includeInactiveData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeInactiveData)), __LINE__);
        }
        $this->IncludeInactiveData = $includeInactiveData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceTimesSelection_V4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
