<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendReeferCommandResultInfo StructType
 * @subpackage Structs
 */
class SendReeferCommandResultInfo extends AbstractStructBase
{
    /**
     * The ReeferCommandId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReeferCommandId;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerItem
     */
    public $Trailer;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleItem
     */
    public $Vehicle;
    /**
     * Constructor method for SendReeferCommandResultInfo
     * @uses SendReeferCommandResultInfo::setReeferCommandId()
     * @uses SendReeferCommandResultInfo::setTrailer()
     * @uses SendReeferCommandResultInfo::setVehicle()
     * @param int $reeferCommandId
     * @param \StructType\TrailerItem $trailer
     * @param \StructType\VehicleItem $vehicle
     */
    public function __construct($reeferCommandId = null, \StructType\TrailerItem $trailer = null, \StructType\VehicleItem $vehicle = null)
    {
        $this
            ->setReeferCommandId($reeferCommandId)
            ->setTrailer($trailer)
            ->setVehicle($vehicle);
    }
    /**
     * Get ReeferCommandId value
     * @return int
     */
    public function getReeferCommandId()
    {
        return $this->ReeferCommandId;
    }
    /**
     * Set ReeferCommandId value
     * @param int $reeferCommandId
     * @return \StructType\SendReeferCommandResultInfo
     */
    public function setReeferCommandId($reeferCommandId = null)
    {
        // validation for constraint: int
        if (!is_null($reeferCommandId) && !is_numeric($reeferCommandId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reeferCommandId)), __LINE__);
        }
        $this->ReeferCommandId = $reeferCommandId;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\TrailerItem|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\TrailerItem $trailer
     * @return \StructType\SendReeferCommandResultInfo
     */
    public function setTrailer(\StructType\TrailerItem $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\VehicleItem|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\VehicleItem $vehicle
     * @return \StructType\SendReeferCommandResultInfo
     */
    public function setVehicle(\StructType\VehicleItem $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendReeferCommandResultInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
