<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefuelReportSelection_V2 StructType
 * @subpackage Structs
 */
class RefuelReportSelection_V2 extends RefuelReportSelection
{
    /**
     * The IncludePreviousRefuel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludePreviousRefuel;
    /**
     * The CountryCodeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CountryCodeType;
    /**
     * The FuelTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $FuelTypes;
    /**
     * Constructor method for RefuelReportSelection_V2
     * @uses RefuelReportSelection_V2::setIncludePreviousRefuel()
     * @uses RefuelReportSelection_V2::setCountryCodeType()
     * @uses RefuelReportSelection_V2::setFuelTypes()
     * @param bool $includePreviousRefuel
     * @param string $countryCodeType
     * @param \ArrayType\ArrayOfInt $fuelTypes
     */
    public function __construct($includePreviousRefuel = null, $countryCodeType = null, \ArrayType\ArrayOfInt $fuelTypes = null)
    {
        $this
            ->setIncludePreviousRefuel($includePreviousRefuel)
            ->setCountryCodeType($countryCodeType)
            ->setFuelTypes($fuelTypes);
    }
    /**
     * Get IncludePreviousRefuel value
     * @return bool
     */
    public function getIncludePreviousRefuel()
    {
        return $this->IncludePreviousRefuel;
    }
    /**
     * Set IncludePreviousRefuel value
     * @param bool $includePreviousRefuel
     * @return \StructType\RefuelReportSelection_V2
     */
    public function setIncludePreviousRefuel($includePreviousRefuel = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePreviousRefuel) && !is_bool($includePreviousRefuel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includePreviousRefuel)), __LINE__);
        }
        $this->IncludePreviousRefuel = $includePreviousRefuel;
        return $this;
    }
    /**
     * Get CountryCodeType value
     * @return string
     */
    public function getCountryCodeType()
    {
        return $this->CountryCodeType;
    }
    /**
     * Set CountryCodeType value
     * @uses \EnumType\CountryCodeTypes::valueIsValid()
     * @uses \EnumType\CountryCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryCodeType
     * @return \StructType\RefuelReportSelection_V2
     */
    public function setCountryCodeType($countryCodeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryCodeTypes::valueIsValid($countryCodeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $countryCodeType, implode(', ', \EnumType\CountryCodeTypes::getValidValues())), __LINE__);
        }
        $this->CountryCodeType = $countryCodeType;
        return $this;
    }
    /**
     * Get FuelTypes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getFuelTypes()
    {
        return $this->FuelTypes;
    }
    /**
     * Set FuelTypes value
     * @param \ArrayType\ArrayOfInt $fuelTypes
     * @return \StructType\RefuelReportSelection_V2
     */
    public function setFuelTypes(\ArrayType\ArrayOfInt $fuelTypes = null)
    {
        $this->FuelTypes = $fuelTypes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RefuelReportSelection_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
