<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReeferCommand StructType
 * @subpackage Structs
 */
class ReeferCommand extends AbstractStructBase
{
    /**
     * The ReeferCommandType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReeferCommandType;
    /**
     * The Zone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Zone;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Trailer;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for ReeferCommand
     * @uses ReeferCommand::setReeferCommandType()
     * @uses ReeferCommand::setZone()
     * @uses ReeferCommand::setTrailer()
     * @uses ReeferCommand::setVehicle()
     * @uses ReeferCommand::setValue()
     * @param string $reeferCommandType
     * @param int $zone
     * @param \StructType\IdentifierVehicle $trailer
     * @param \StructType\IdentifierVehicle $vehicle
     * @param string $value
     */
    public function __construct($reeferCommandType = null, $zone = null, \StructType\IdentifierVehicle $trailer = null, \StructType\IdentifierVehicle $vehicle = null, $value = null)
    {
        $this
            ->setReeferCommandType($reeferCommandType)
            ->setZone($zone)
            ->setTrailer($trailer)
            ->setVehicle($vehicle)
            ->setValue($value);
    }
    /**
     * Get ReeferCommandType value
     * @return string
     */
    public function getReeferCommandType()
    {
        return $this->ReeferCommandType;
    }
    /**
     * Set ReeferCommandType value
     * @uses \EnumType\ReeferCommandType::valueIsValid()
     * @uses \EnumType\ReeferCommandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reeferCommandType
     * @return \StructType\ReeferCommand
     */
    public function setReeferCommandType($reeferCommandType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReeferCommandType::valueIsValid($reeferCommandType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reeferCommandType, implode(', ', \EnumType\ReeferCommandType::getValidValues())), __LINE__);
        }
        $this->ReeferCommandType = $reeferCommandType;
        return $this;
    }
    /**
     * Get Zone value
     * @return int
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \StructType\ReeferCommand
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !is_numeric($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicle $trailer
     * @return \StructType\ReeferCommand
     */
    public function setTrailer(\StructType\IdentifierVehicle $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\ReeferCommand
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\ReeferCommand
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReeferCommand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
