<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductInterfaceResult_v3 StructType
 * @subpackage Structs
 */
class ProductInterfaceResult_v3 extends ProductInterfaceResult_v2
{
    /**
     * The CheckoffType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckoffType;
    /**
     * Constructor method for ProductInterfaceResult_v3
     * @uses ProductInterfaceResult_v3::setCheckoffType()
     * @param string $checkoffType
     */
    public function __construct($checkoffType = null)
    {
        $this
            ->setCheckoffType($checkoffType);
    }
    /**
     * Get CheckoffType value
     * @return string
     */
    public function getCheckoffType()
    {
        return $this->CheckoffType;
    }
    /**
     * Set CheckoffType value
     * @uses \EnumType\EnumCheckOffType::valueIsValid()
     * @uses \EnumType\EnumCheckOffType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $checkoffType
     * @return \StructType\ProductInterfaceResult_v3
     */
    public function setCheckoffType($checkoffType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCheckOffType::valueIsValid($checkoffType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $checkoffType, implode(', ', \EnumType\EnumCheckOffType::getValidValues())), __LINE__);
        }
        $this->CheckoffType = $checkoffType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductInterfaceResult_v3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
