<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductIdentifier StructType
 * @subpackage Structs
 */
class ProductIdentifier extends AbstractStructBase
{
    /**
     * The TransicsProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsProductID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductID;
    /**
     * Constructor method for ProductIdentifier
     * @uses ProductIdentifier::setTransicsProductID()
     * @uses ProductIdentifier::setProductID()
     * @param int $transicsProductID
     * @param string $productID
     */
    public function __construct($transicsProductID = null, $productID = null)
    {
        $this
            ->setTransicsProductID($transicsProductID)
            ->setProductID($productID);
    }
    /**
     * Get TransicsProductID value
     * @return int
     */
    public function getTransicsProductID()
    {
        return $this->TransicsProductID;
    }
    /**
     * Set TransicsProductID value
     * @param int $transicsProductID
     * @return \StructType\ProductIdentifier
     */
    public function setTransicsProductID($transicsProductID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsProductID) && !is_numeric($transicsProductID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsProductID)), __LINE__);
        }
        $this->TransicsProductID = $transicsProductID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return string|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param string $productID
     * @return \StructType\ProductIdentifier
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: string
        if (!is_null($productID) && !is_string($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
