<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionSelection_V3 StructType
 * @subpackage Structs
 */
class PositionSelection_V3 extends PositionSelection_V2
{
    /**
     * The DataSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataSource;
    /**
     * Constructor method for PositionSelection_V3
     * @uses PositionSelection_V3::setDataSource()
     * @param string $dataSource
     */
    public function __construct($dataSource = null)
    {
        $this
            ->setDataSource($dataSource);
    }
    /**
     * Get DataSource value
     * @return string
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @uses \EnumType\PositionDataSource::valueIsValid()
     * @uses \EnumType\PositionDataSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataSource
     * @return \StructType\PositionSelection_V3
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PositionDataSource::valueIsValid($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataSource, implode(', ', \EnumType\PositionDataSource::getValidValues())), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PositionSelection_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
