<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionItemResult StructType
 * @subpackage Structs
 */
class PositionItemResult extends Position
{
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The Kms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Kms;
    /**
     * The Speed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Speed;
    /**
     * The FuelLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FuelLevel;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityInfo
     */
    public $Activity;
    /**
     * The AddressInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressInfo;
    /**
     * The DistanceFromCapitol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromCapitol;
    /**
     * The DistanceFromLargeCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromLargeCity;
    /**
     * The DistanceFromSmallCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromSmallCity;
    /**
     * The DistanceFromPointOfInterest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromPointOfInterest;
    /**
     * Constructor method for PositionItemResult
     * @uses PositionItemResult::setDateTime()
     * @uses PositionItemResult::setKms()
     * @uses PositionItemResult::setSpeed()
     * @uses PositionItemResult::setFuelLevel()
     * @uses PositionItemResult::setVehicle()
     * @uses PositionItemResult::setTrailer()
     * @uses PositionItemResult::setDriver()
     * @uses PositionItemResult::setActivity()
     * @uses PositionItemResult::setAddressInfo()
     * @uses PositionItemResult::setDistanceFromCapitol()
     * @uses PositionItemResult::setDistanceFromLargeCity()
     * @uses PositionItemResult::setDistanceFromSmallCity()
     * @uses PositionItemResult::setDistanceFromPointOfInterest()
     * @param string $dateTime
     * @param int $kms
     * @param float $speed
     * @param int $fuelLevel
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\ActivityInfo $activity
     * @param string $addressInfo
     * @param string $distanceFromCapitol
     * @param string $distanceFromLargeCity
     * @param string $distanceFromSmallCity
     * @param string $distanceFromPointOfInterest
     */
    public function __construct($dateTime = null, $kms = null, $speed = null, $fuelLevel = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierPerson $driver = null, \StructType\ActivityInfo $activity = null, $addressInfo = null, $distanceFromCapitol = null, $distanceFromLargeCity = null, $distanceFromSmallCity = null, $distanceFromPointOfInterest = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setKms($kms)
            ->setSpeed($speed)
            ->setFuelLevel($fuelLevel)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setActivity($activity)
            ->setAddressInfo($addressInfo)
            ->setDistanceFromCapitol($distanceFromCapitol)
            ->setDistanceFromLargeCity($distanceFromLargeCity)
            ->setDistanceFromSmallCity($distanceFromSmallCity)
            ->setDistanceFromPointOfInterest($distanceFromPointOfInterest);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\PositionItemResult
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Kms value
     * @return int
     */
    public function getKms()
    {
        return $this->Kms;
    }
    /**
     * Set Kms value
     * @param int $kms
     * @return \StructType\PositionItemResult
     */
    public function setKms($kms = null)
    {
        // validation for constraint: int
        if (!is_null($kms) && !is_numeric($kms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kms)), __LINE__);
        }
        $this->Kms = $kms;
        return $this;
    }
    /**
     * Get Speed value
     * @return float
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param float $speed
     * @return \StructType\PositionItemResult
     */
    public function setSpeed($speed = null)
    {
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\PositionItemResult
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !is_numeric($fuelLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\PositionItemResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\PositionItemResult
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\PositionItemResult
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityInfo|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\ActivityInfo $activity
     * @return \StructType\PositionItemResult
     */
    public function setActivity(\StructType\ActivityInfo $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return string|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param string $addressInfo
     * @return \StructType\PositionItemResult
     */
    public function setAddressInfo($addressInfo = null)
    {
        // validation for constraint: string
        if (!is_null($addressInfo) && !is_string($addressInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressInfo)), __LINE__);
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get DistanceFromCapitol value
     * @return string|null
     */
    public function getDistanceFromCapitol()
    {
        return $this->DistanceFromCapitol;
    }
    /**
     * Set DistanceFromCapitol value
     * @param string $distanceFromCapitol
     * @return \StructType\PositionItemResult
     */
    public function setDistanceFromCapitol($distanceFromCapitol = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromCapitol) && !is_string($distanceFromCapitol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceFromCapitol)), __LINE__);
        }
        $this->DistanceFromCapitol = $distanceFromCapitol;
        return $this;
    }
    /**
     * Get DistanceFromLargeCity value
     * @return string|null
     */
    public function getDistanceFromLargeCity()
    {
        return $this->DistanceFromLargeCity;
    }
    /**
     * Set DistanceFromLargeCity value
     * @param string $distanceFromLargeCity
     * @return \StructType\PositionItemResult
     */
    public function setDistanceFromLargeCity($distanceFromLargeCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromLargeCity) && !is_string($distanceFromLargeCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceFromLargeCity)), __LINE__);
        }
        $this->DistanceFromLargeCity = $distanceFromLargeCity;
        return $this;
    }
    /**
     * Get DistanceFromSmallCity value
     * @return string|null
     */
    public function getDistanceFromSmallCity()
    {
        return $this->DistanceFromSmallCity;
    }
    /**
     * Set DistanceFromSmallCity value
     * @param string $distanceFromSmallCity
     * @return \StructType\PositionItemResult
     */
    public function setDistanceFromSmallCity($distanceFromSmallCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromSmallCity) && !is_string($distanceFromSmallCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceFromSmallCity)), __LINE__);
        }
        $this->DistanceFromSmallCity = $distanceFromSmallCity;
        return $this;
    }
    /**
     * Get DistanceFromPointOfInterest value
     * @return string|null
     */
    public function getDistanceFromPointOfInterest()
    {
        return $this->DistanceFromPointOfInterest;
    }
    /**
     * Set DistanceFromPointOfInterest value
     * @param string $distanceFromPointOfInterest
     * @return \StructType\PositionItemResult
     */
    public function setDistanceFromPointOfInterest($distanceFromPointOfInterest = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromPointOfInterest) && !is_string($distanceFromPointOfInterest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceFromPointOfInterest)), __LINE__);
        }
        $this->DistanceFromPointOfInterest = $distanceFromPointOfInterest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PositionItemResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
