<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningUnplannedInfoSelection StructType
 * @subpackage Structs
 */
class PlanningUnplannedInfoSelection extends AbstractStructBase
{
    /**
     * The PlanningSelectionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlanningSelectionType;
    /**
     * The DateTimeRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * The SelectionFromToday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $SelectionFromToday;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * Constructor method for PlanningUnplannedInfoSelection
     * @uses PlanningUnplannedInfoSelection::setPlanningSelectionType()
     * @uses PlanningUnplannedInfoSelection::setDateTimeRange()
     * @uses PlanningUnplannedInfoSelection::setSelectionFromToday()
     * @uses PlanningUnplannedInfoSelection::setDriver()
     * @param string $planningSelectionType
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @param \StructType\Identifier $driver
     */
    public function __construct($planningSelectionType = null, \StructType\DateTimeRangeSelection $dateTimeRange = null, \StructType\DateTimeSelection $selectionFromToday = null, \StructType\Identifier $driver = null)
    {
        $this
            ->setPlanningSelectionType($planningSelectionType)
            ->setDateTimeRange($dateTimeRange)
            ->setSelectionFromToday($selectionFromToday)
            ->setDriver($driver);
    }
    /**
     * Get PlanningSelectionType value
     * @return string
     */
    public function getPlanningSelectionType()
    {
        return $this->PlanningSelectionType;
    }
    /**
     * Set PlanningSelectionType value
     * @uses \EnumType\EnumPlanningItemSelectionType::valueIsValid()
     * @uses \EnumType\EnumPlanningItemSelectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $planningSelectionType
     * @return \StructType\PlanningUnplannedInfoSelection
     */
    public function setPlanningSelectionType($planningSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningItemSelectionType::valueIsValid($planningSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $planningSelectionType, implode(', ', \EnumType\EnumPlanningItemSelectionType::getValidValues())), __LINE__);
        }
        $this->PlanningSelectionType = $planningSelectionType;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\PlanningUnplannedInfoSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Get SelectionFromToday value
     * @return \StructType\DateTimeSelection|null
     */
    public function getSelectionFromToday()
    {
        return $this->SelectionFromToday;
    }
    /**
     * Set SelectionFromToday value
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @return \StructType\PlanningUnplannedInfoSelection
     */
    public function setSelectionFromToday(\StructType\DateTimeSelection $selectionFromToday = null)
    {
        $this->SelectionFromToday = $selectionFromToday;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\PlanningUnplannedInfoSelection
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlanningUnplannedInfoSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
