<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningPlaceItemResult StructType
 * @subpackage Structs
 */
class PlanningPlaceItemResult extends PlaceItemResult
{
    /**
     * The SalesPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SalesPrice;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerResult_V2
     */
    public $Customer;
    /**
     * The Shipper
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipperResult_V2
     */
    public $Shipper;
    /**
     * The AddressDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressDescription;
    /**
     * Constructor method for PlanningPlaceItemResult
     * @uses PlanningPlaceItemResult::setSalesPrice()
     * @uses PlanningPlaceItemResult::setCustomer()
     * @uses PlanningPlaceItemResult::setShipper()
     * @uses PlanningPlaceItemResult::setAddressDescription()
     * @param float $salesPrice
     * @param \StructType\CustomerResult_V2 $customer
     * @param \StructType\ShipperResult_V2 $shipper
     * @param string $addressDescription
     */
    public function __construct($salesPrice = null, \StructType\CustomerResult_V2 $customer = null, \StructType\ShipperResult_V2 $shipper = null, $addressDescription = null)
    {
        $this
            ->setSalesPrice($salesPrice)
            ->setCustomer($customer)
            ->setShipper($shipper)
            ->setAddressDescription($addressDescription);
    }
    /**
     * Get SalesPrice value
     * @return float
     */
    public function getSalesPrice()
    {
        return $this->SalesPrice;
    }
    /**
     * Set SalesPrice value
     * @param float $salesPrice
     * @return \StructType\PlanningPlaceItemResult
     */
    public function setSalesPrice($salesPrice = null)
    {
        $this->SalesPrice = $salesPrice;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerResult_V2|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerResult_V2 $customer
     * @return \StructType\PlanningPlaceItemResult
     */
    public function setCustomer(\StructType\CustomerResult_V2 $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\ShipperResult_V2|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\ShipperResult_V2 $shipper
     * @return \StructType\PlanningPlaceItemResult
     */
    public function setShipper(\StructType\ShipperResult_V2 $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get AddressDescription value
     * @return string|null
     */
    public function getAddressDescription()
    {
        return $this->AddressDescription;
    }
    /**
     * Set AddressDescription value
     * @param string $addressDescription
     * @return \StructType\PlanningPlaceItemResult
     */
    public function setAddressDescription($addressDescription = null)
    {
        // validation for constraint: string
        if (!is_null($addressDescription) && !is_string($addressDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressDescription)), __LINE__);
        }
        $this->AddressDescription = $addressDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlanningPlaceItemResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
