<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningItem StructType
 * @subpackage Structs
 */
class PlanningItem extends AbstractStructBase
{
    /**
     * The TransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerID;
    /**
     * The DriverDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * Constructor method for PlanningItem
     * @uses PlanningItem::setTransicsID()
     * @uses PlanningItem::setCustomerID()
     * @uses PlanningItem::setDriverDisplay()
     * @param int $transicsID
     * @param string $customerID
     * @param string $driverDisplay
     */
    public function __construct($transicsID = null, $customerID = null, $driverDisplay = null)
    {
        $this
            ->setTransicsID($transicsID)
            ->setCustomerID($customerID)
            ->setDriverDisplay($driverDisplay);
    }
    /**
     * Get TransicsID value
     * @return int
     */
    public function getTransicsID()
    {
        return $this->TransicsID;
    }
    /**
     * Set TransicsID value
     * @param int $transicsID
     * @return \StructType\PlanningItem
     */
    public function setTransicsID($transicsID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsID) && !is_numeric($transicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsID)), __LINE__);
        }
        $this->TransicsID = $transicsID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \StructType\PlanningItem
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\PlanningItem
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlanningItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
