<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceIdentifier_V4 StructType
 * @subpackage Structs
 */
class PlaceIdentifier_V4 extends AbstractStructBase
{
    /**
     * The TransicsId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsId;
    /**
     * The PlaceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceId;
    /**
     * Constructor method for PlaceIdentifier_V4
     * @uses PlaceIdentifier_V4::setTransicsId()
     * @uses PlaceIdentifier_V4::setPlaceId()
     * @param int $transicsId
     * @param string $placeId
     */
    public function __construct($transicsId = null, $placeId = null)
    {
        $this
            ->setTransicsId($transicsId)
            ->setPlaceId($placeId);
    }
    /**
     * Get TransicsId value
     * @return int
     */
    public function getTransicsId()
    {
        return $this->TransicsId;
    }
    /**
     * Set TransicsId value
     * @param int $transicsId
     * @return \StructType\PlaceIdentifier_V4
     */
    public function setTransicsId($transicsId = null)
    {
        // validation for constraint: int
        if (!is_null($transicsId) && !is_numeric($transicsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsId)), __LINE__);
        }
        $this->TransicsId = $transicsId;
        return $this;
    }
    /**
     * Get PlaceId value
     * @return string|null
     */
    public function getPlaceId()
    {
        return $this->PlaceId;
    }
    /**
     * Set PlaceId value
     * @param string $placeId
     * @return \StructType\PlaceIdentifier_V4
     */
    public function setPlaceId($placeId = null)
    {
        // validation for constraint: string
        if (!is_null($placeId) && !is_string($placeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeId)), __LINE__);
        }
        $this->PlaceId = $placeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceIdentifier_V4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
