<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceIdentifier_V2 StructType
 * @subpackage Structs
 */
class PlaceIdentifier_V2 extends AbstractStructBase
{
    /**
     * The TransicsPlaceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsPlaceID;
    /**
     * The PlaceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceID;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerResult
     */
    public $Customer;
    /**
     * The Shipper
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipperResult
     */
    public $Shipper;
    /**
     * Constructor method for PlaceIdentifier_V2
     * @uses PlaceIdentifier_V2::setTransicsPlaceID()
     * @uses PlaceIdentifier_V2::setPlaceID()
     * @uses PlaceIdentifier_V2::setCustomer()
     * @uses PlaceIdentifier_V2::setShipper()
     * @param int $transicsPlaceID
     * @param string $placeID
     * @param \StructType\CustomerResult $customer
     * @param \StructType\ShipperResult $shipper
     */
    public function __construct($transicsPlaceID = null, $placeID = null, \StructType\CustomerResult $customer = null, \StructType\ShipperResult $shipper = null)
    {
        $this
            ->setTransicsPlaceID($transicsPlaceID)
            ->setPlaceID($placeID)
            ->setCustomer($customer)
            ->setShipper($shipper);
    }
    /**
     * Get TransicsPlaceID value
     * @return int
     */
    public function getTransicsPlaceID()
    {
        return $this->TransicsPlaceID;
    }
    /**
     * Set TransicsPlaceID value
     * @param int $transicsPlaceID
     * @return \StructType\PlaceIdentifier_V2
     */
    public function setTransicsPlaceID($transicsPlaceID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsPlaceID) && !is_numeric($transicsPlaceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsPlaceID)), __LINE__);
        }
        $this->TransicsPlaceID = $transicsPlaceID;
        return $this;
    }
    /**
     * Get PlaceID value
     * @return string|null
     */
    public function getPlaceID()
    {
        return $this->PlaceID;
    }
    /**
     * Set PlaceID value
     * @param string $placeID
     * @return \StructType\PlaceIdentifier_V2
     */
    public function setPlaceID($placeID = null)
    {
        // validation for constraint: string
        if (!is_null($placeID) && !is_string($placeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeID)), __LINE__);
        }
        $this->PlaceID = $placeID;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerResult|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerResult $customer
     * @return \StructType\PlaceIdentifier_V2
     */
    public function setCustomer(\StructType\CustomerResult $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\ShipperResult|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\ShipperResult $shipper
     * @return \StructType\PlaceIdentifier_V2
     */
    public function setShipper(\StructType\ShipperResult $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceIdentifier_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
