<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Place StructType
 * @subpackage Structs
 */
abstract class Place extends AbstractStructBase
{
    /**
     * The OrderSeq
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderSeq;
    /**
     * The ExecutionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionDate;
    /**
     * The AlarmTimeETA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AlarmTimeETA;
    /**
     * The CustomNr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomNr;
    /**
     * The PlaceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceId;
    /**
     * The DriverDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * The DispatcherDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DispatcherDisplay;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The References
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reference
     */
    public $References;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityPlace
     */
    public $Activity;
    /**
     * Constructor method for Place
     * @uses Place::setOrderSeq()
     * @uses Place::setExecutionDate()
     * @uses Place::setAlarmTimeETA()
     * @uses Place::setCustomNr()
     * @uses Place::setPlaceId()
     * @uses Place::setDriverDisplay()
     * @uses Place::setDispatcherDisplay()
     * @uses Place::setComment()
     * @uses Place::setReferences()
     * @uses Place::setActivity()
     * @param int $orderSeq
     * @param string $executionDate
     * @param int $alarmTimeETA
     * @param int $customNr
     * @param string $placeId
     * @param string $driverDisplay
     * @param string $dispatcherDisplay
     * @param string $comment
     * @param \StructType\Reference $references
     * @param \StructType\ActivityPlace $activity
     */
    public function __construct($orderSeq = null, $executionDate = null, $alarmTimeETA = null, $customNr = null, $placeId = null, $driverDisplay = null, $dispatcherDisplay = null, $comment = null, \StructType\Reference $references = null, \StructType\ActivityPlace $activity = null)
    {
        $this
            ->setOrderSeq($orderSeq)
            ->setExecutionDate($executionDate)
            ->setAlarmTimeETA($alarmTimeETA)
            ->setCustomNr($customNr)
            ->setPlaceId($placeId)
            ->setDriverDisplay($driverDisplay)
            ->setDispatcherDisplay($dispatcherDisplay)
            ->setComment($comment)
            ->setReferences($references)
            ->setActivity($activity);
    }
    /**
     * Get OrderSeq value
     * @return int
     */
    public function getOrderSeq()
    {
        return $this->OrderSeq;
    }
    /**
     * Set OrderSeq value
     * @param int $orderSeq
     * @return \StructType\Place
     */
    public function setOrderSeq($orderSeq = null)
    {
        // validation for constraint: int
        if (!is_null($orderSeq) && !is_numeric($orderSeq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderSeq)), __LINE__);
        }
        $this->OrderSeq = $orderSeq;
        return $this;
    }
    /**
     * Get ExecutionDate value
     * @return string
     */
    public function getExecutionDate()
    {
        return $this->ExecutionDate;
    }
    /**
     * Set ExecutionDate value
     * @param string $executionDate
     * @return \StructType\Place
     */
    public function setExecutionDate($executionDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionDate) && !is_string($executionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($executionDate)), __LINE__);
        }
        $this->ExecutionDate = $executionDate;
        return $this;
    }
    /**
     * Get AlarmTimeETA value
     * @return int
     */
    public function getAlarmTimeETA()
    {
        return $this->AlarmTimeETA;
    }
    /**
     * Set AlarmTimeETA value
     * @param int $alarmTimeETA
     * @return \StructType\Place
     */
    public function setAlarmTimeETA($alarmTimeETA = null)
    {
        // validation for constraint: int
        if (!is_null($alarmTimeETA) && !is_numeric($alarmTimeETA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($alarmTimeETA)), __LINE__);
        }
        $this->AlarmTimeETA = $alarmTimeETA;
        return $this;
    }
    /**
     * Get CustomNr value
     * @return int
     */
    public function getCustomNr()
    {
        return $this->CustomNr;
    }
    /**
     * Set CustomNr value
     * @param int $customNr
     * @return \StructType\Place
     */
    public function setCustomNr($customNr = null)
    {
        // validation for constraint: int
        if (!is_null($customNr) && !is_numeric($customNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customNr)), __LINE__);
        }
        $this->CustomNr = $customNr;
        return $this;
    }
    /**
     * Get PlaceId value
     * @return string|null
     */
    public function getPlaceId()
    {
        return $this->PlaceId;
    }
    /**
     * Set PlaceId value
     * @param string $placeId
     * @return \StructType\Place
     */
    public function setPlaceId($placeId = null)
    {
        // validation for constraint: string
        if (!is_null($placeId) && !is_string($placeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeId)), __LINE__);
        }
        $this->PlaceId = $placeId;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\Place
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Get DispatcherDisplay value
     * @return string|null
     */
    public function getDispatcherDisplay()
    {
        return $this->DispatcherDisplay;
    }
    /**
     * Set DispatcherDisplay value
     * @param string $dispatcherDisplay
     * @return \StructType\Place
     */
    public function setDispatcherDisplay($dispatcherDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($dispatcherDisplay) && !is_string($dispatcherDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dispatcherDisplay)), __LINE__);
        }
        $this->DispatcherDisplay = $dispatcherDisplay;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Place
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get References value
     * @return \StructType\Reference|null
     */
    public function getReferences()
    {
        return $this->References;
    }
    /**
     * Set References value
     * @param \StructType\Reference $references
     * @return \StructType\Place
     */
    public function setReferences(\StructType\Reference $references = null)
    {
        $this->References = $references;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\ActivityPlace|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\ActivityPlace $activity
     * @return \StructType\Place
     */
    public function setActivity(\StructType\ActivityPlace $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Place
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
