<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonHRInfo StructType
 * @subpackage Structs
 */
class PersonHRInfo extends AbstractStructBase
{
    /**
     * The Employed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Employed;
    /**
     * The Resigned
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Resigned;
    /**
     * The Birthday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The BirthCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthCity;
    /**
     * The Rating
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rating;
    /**
     * The HoursPerMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HoursPerMonth;
    /**
     * The HourlyRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HourlyRate;
    /**
     * The Statuses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonStatuses
     */
    public $Statuses;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonTags
     */
    public $Tags;
    /**
     * Constructor method for PersonHRInfo
     * @uses PersonHRInfo::setEmployed()
     * @uses PersonHRInfo::setResigned()
     * @uses PersonHRInfo::setBirthday()
     * @uses PersonHRInfo::setBirthCity()
     * @uses PersonHRInfo::setRating()
     * @uses PersonHRInfo::setHoursPerMonth()
     * @uses PersonHRInfo::setHourlyRate()
     * @uses PersonHRInfo::setStatuses()
     * @uses PersonHRInfo::setTags()
     * @param string $employed
     * @param string $resigned
     * @param string $birthday
     * @param string $birthCity
     * @param string $rating
     * @param string $hoursPerMonth
     * @param string $hourlyRate
     * @param \StructType\PersonStatuses $statuses
     * @param \StructType\PersonTags $tags
     */
    public function __construct($employed = null, $resigned = null, $birthday = null, $birthCity = null, $rating = null, $hoursPerMonth = null, $hourlyRate = null, \StructType\PersonStatuses $statuses = null, \StructType\PersonTags $tags = null)
    {
        $this
            ->setEmployed($employed)
            ->setResigned($resigned)
            ->setBirthday($birthday)
            ->setBirthCity($birthCity)
            ->setRating($rating)
            ->setHoursPerMonth($hoursPerMonth)
            ->setHourlyRate($hourlyRate)
            ->setStatuses($statuses)
            ->setTags($tags);
    }
    /**
     * Get Employed value
     * @return string
     */
    public function getEmployed()
    {
        return $this->Employed;
    }
    /**
     * Set Employed value
     * @param string $employed
     * @return \StructType\PersonHRInfo
     */
    public function setEmployed($employed = null)
    {
        // validation for constraint: string
        if (!is_null($employed) && !is_string($employed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($employed)), __LINE__);
        }
        $this->Employed = $employed;
        return $this;
    }
    /**
     * Get Resigned value
     * @return string
     */
    public function getResigned()
    {
        return $this->Resigned;
    }
    /**
     * Set Resigned value
     * @param string $resigned
     * @return \StructType\PersonHRInfo
     */
    public function setResigned($resigned = null)
    {
        // validation for constraint: string
        if (!is_null($resigned) && !is_string($resigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resigned)), __LINE__);
        }
        $this->Resigned = $resigned;
        return $this;
    }
    /**
     * Get Birthday value
     * @return string
     */
    public function getBirthday()
    {
        return $this->Birthday;
    }
    /**
     * Set Birthday value
     * @param string $birthday
     * @return \StructType\PersonHRInfo
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthday)), __LINE__);
        }
        $this->Birthday = $birthday;
        return $this;
    }
    /**
     * Get BirthCity value
     * @return string|null
     */
    public function getBirthCity()
    {
        return $this->BirthCity;
    }
    /**
     * Set BirthCity value
     * @param string $birthCity
     * @return \StructType\PersonHRInfo
     */
    public function setBirthCity($birthCity = null)
    {
        // validation for constraint: string
        if (!is_null($birthCity) && !is_string($birthCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthCity)), __LINE__);
        }
        $this->BirthCity = $birthCity;
        return $this;
    }
    /**
     * Get Rating value
     * @return string|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param string $rating
     * @return \StructType\PersonHRInfo
     */
    public function setRating($rating = null)
    {
        // validation for constraint: string
        if (!is_null($rating) && !is_string($rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rating)), __LINE__);
        }
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Get HoursPerMonth value
     * @return string|null
     */
    public function getHoursPerMonth()
    {
        return $this->HoursPerMonth;
    }
    /**
     * Set HoursPerMonth value
     * @param string $hoursPerMonth
     * @return \StructType\PersonHRInfo
     */
    public function setHoursPerMonth($hoursPerMonth = null)
    {
        // validation for constraint: string
        if (!is_null($hoursPerMonth) && !is_string($hoursPerMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hoursPerMonth)), __LINE__);
        }
        $this->HoursPerMonth = $hoursPerMonth;
        return $this;
    }
    /**
     * Get HourlyRate value
     * @return string|null
     */
    public function getHourlyRate()
    {
        return $this->HourlyRate;
    }
    /**
     * Set HourlyRate value
     * @param string $hourlyRate
     * @return \StructType\PersonHRInfo
     */
    public function setHourlyRate($hourlyRate = null)
    {
        // validation for constraint: string
        if (!is_null($hourlyRate) && !is_string($hourlyRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hourlyRate)), __LINE__);
        }
        $this->HourlyRate = $hourlyRate;
        return $this;
    }
    /**
     * Get Statuses value
     * @return \StructType\PersonStatuses|null
     */
    public function getStatuses()
    {
        return $this->Statuses;
    }
    /**
     * Set Statuses value
     * @param \StructType\PersonStatuses $statuses
     * @return \StructType\PersonHRInfo
     */
    public function setStatuses(\StructType\PersonStatuses $statuses = null)
    {
        $this->Statuses = $statuses;
        return $this;
    }
    /**
     * Get Tags value
     * @return \StructType\PersonTags|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \StructType\PersonTags $tags
     * @return \StructType\PersonHRInfo
     */
    public function setTags(\StructType\PersonTags $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonHRInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
