<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PeriodSelectionWithDateType StructType
 * @subpackage Structs
 */
class PeriodSelectionWithDateType extends DateTimeRangeSelection
{
    /**
     * The DateTypeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTypeSelection;
    /**
     * Constructor method for PeriodSelectionWithDateType
     * @uses PeriodSelectionWithDateType::setDateTypeSelection()
     * @param string $dateTypeSelection
     */
    public function __construct($dateTypeSelection = null)
    {
        $this
            ->setDateTypeSelection($dateTypeSelection);
    }
    /**
     * Get DateTypeSelection value
     * @return string
     */
    public function getDateTypeSelection()
    {
        return $this->DateTypeSelection;
    }
    /**
     * Set DateTypeSelection value
     * @uses \EnumType\EnumDateTypeSelection::valueIsValid()
     * @uses \EnumType\EnumDateTypeSelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateTypeSelection
     * @return \StructType\PeriodSelectionWithDateType
     */
    public function setDateTypeSelection($dateTypeSelection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumDateTypeSelection::valueIsValid($dateTypeSelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dateTypeSelection, implode(', ', \EnumType\EnumDateTypeSelection::getValidValues())), __LINE__);
        }
        $this->DateTypeSelection = $dateTypeSelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PeriodSelectionWithDateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
