<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PalletReportSelection StructType
 * @subpackage Structs
 */
class PalletReportSelection extends AbstractStructBase
{
    /**
     * The IncludePosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludePosition;
    /**
     * The DateTimeRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The TripID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripID;
    /**
     * The PlaceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceID;
    /**
     * The PositionRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionRangeSelection
     */
    public $PositionRange;
    /**
     * Constructor method for PalletReportSelection
     * @uses PalletReportSelection::setIncludePosition()
     * @uses PalletReportSelection::setDateTimeRange()
     * @uses PalletReportSelection::setDrivers()
     * @uses PalletReportSelection::setVehicles()
     * @uses PalletReportSelection::setTripID()
     * @uses PalletReportSelection::setPlaceID()
     * @uses PalletReportSelection::setPositionRange()
     * @param bool $includePosition
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param string $tripID
     * @param string $placeID
     * @param \StructType\PositionRangeSelection $positionRange
     */
    public function __construct($includePosition = null, \StructType\DateTimeRangeSelection $dateTimeRange = null, \ArrayType\ArrayOfIdentifier $drivers = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, $tripID = null, $placeID = null, \StructType\PositionRangeSelection $positionRange = null)
    {
        $this
            ->setIncludePosition($includePosition)
            ->setDateTimeRange($dateTimeRange)
            ->setDrivers($drivers)
            ->setVehicles($vehicles)
            ->setTripID($tripID)
            ->setPlaceID($placeID)
            ->setPositionRange($positionRange);
    }
    /**
     * Get IncludePosition value
     * @return bool
     */
    public function getIncludePosition()
    {
        return $this->IncludePosition;
    }
    /**
     * Set IncludePosition value
     * @param bool $includePosition
     * @return \StructType\PalletReportSelection
     */
    public function setIncludePosition($includePosition = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePosition) && !is_bool($includePosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includePosition)), __LINE__);
        }
        $this->IncludePosition = $includePosition;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\PalletReportSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\PalletReportSelection
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\PalletReportSelection
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get TripID value
     * @return string|null
     */
    public function getTripID()
    {
        return $this->TripID;
    }
    /**
     * Set TripID value
     * @param string $tripID
     * @return \StructType\PalletReportSelection
     */
    public function setTripID($tripID = null)
    {
        // validation for constraint: string
        if (!is_null($tripID) && !is_string($tripID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripID)), __LINE__);
        }
        $this->TripID = $tripID;
        return $this;
    }
    /**
     * Get PlaceID value
     * @return string|null
     */
    public function getPlaceID()
    {
        return $this->PlaceID;
    }
    /**
     * Set PlaceID value
     * @param string $placeID
     * @return \StructType\PalletReportSelection
     */
    public function setPlaceID($placeID = null)
    {
        // validation for constraint: string
        if (!is_null($placeID) && !is_string($placeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeID)), __LINE__);
        }
        $this->PlaceID = $placeID;
        return $this;
    }
    /**
     * Get PositionRange value
     * @return \StructType\PositionRangeSelection|null
     */
    public function getPositionRange()
    {
        return $this->PositionRange;
    }
    /**
     * Set PositionRange value
     * @param \StructType\PositionRangeSelection $positionRange
     * @return \StructType\PalletReportSelection
     */
    public function setPositionRange(\StructType\PositionRangeSelection $positionRange = null)
    {
        $this->PositionRange = $positionRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PalletReportSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
