<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POISelection_V2 StructType
 * @subpackage Structs
 */
class POISelection_V2 extends POISelection
{
    /**
     * The CountryCodeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CountryCodeType;
    /**
     * Constructor method for POISelection_V2
     * @uses POISelection_V2::setCountryCodeType()
     * @param string $countryCodeType
     */
    public function __construct($countryCodeType = null)
    {
        $this
            ->setCountryCodeType($countryCodeType);
    }
    /**
     * Get CountryCodeType value
     * @return string
     */
    public function getCountryCodeType()
    {
        return $this->CountryCodeType;
    }
    /**
     * Set CountryCodeType value
     * @uses \EnumType\CountryCodeTypes::valueIsValid()
     * @uses \EnumType\CountryCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryCodeType
     * @return \StructType\POISelection_V2
     */
    public function setCountryCodeType($countryCodeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryCodeTypes::valueIsValid($countryCodeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $countryCodeType, implode(', ', \EnumType\CountryCodeTypes::getValidValues())), __LINE__);
        }
        $this->CountryCodeType = $countryCodeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\POISelection_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
