<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POISelection StructType
 * @subpackage Structs
 */
class POISelection extends AbstractStructBase
{
    /**
     * The POIActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $POIActive;
    /**
     * The IncludeGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeGroups;
    /**
     * The IncludeContactPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeContactPerson;
    /**
     * The IncludeOpeningHours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeOpeningHours;
    /**
     * The IncludeExtraInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeExtraInformation;
    /**
     * The PoiIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $PoiIDs;
    /**
     * The PoiNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $PoiNames;
    /**
     * The POIsNearPosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionArea
     */
    public $POIsNearPosition;
    /**
     * Constructor method for POISelection
     * @uses POISelection::setPOIActive()
     * @uses POISelection::setIncludeGroups()
     * @uses POISelection::setIncludeContactPerson()
     * @uses POISelection::setIncludeOpeningHours()
     * @uses POISelection::setIncludeExtraInformation()
     * @uses POISelection::setPoiIDs()
     * @uses POISelection::setPoiNames()
     * @uses POISelection::setPOIsNearPosition()
     * @param bool $pOIActive
     * @param bool $includeGroups
     * @param bool $includeContactPerson
     * @param bool $includeOpeningHours
     * @param bool $includeExtraInformation
     * @param \ArrayType\ArrayOfInt $poiIDs
     * @param \ArrayType\ArrayOfString $poiNames
     * @param \StructType\PositionArea $pOIsNearPosition
     */
    public function __construct($pOIActive = null, $includeGroups = null, $includeContactPerson = null, $includeOpeningHours = null, $includeExtraInformation = null, \ArrayType\ArrayOfInt $poiIDs = null, \ArrayType\ArrayOfString $poiNames = null, \StructType\PositionArea $pOIsNearPosition = null)
    {
        $this
            ->setPOIActive($pOIActive)
            ->setIncludeGroups($includeGroups)
            ->setIncludeContactPerson($includeContactPerson)
            ->setIncludeOpeningHours($includeOpeningHours)
            ->setIncludeExtraInformation($includeExtraInformation)
            ->setPoiIDs($poiIDs)
            ->setPoiNames($poiNames)
            ->setPOIsNearPosition($pOIsNearPosition);
    }
    /**
     * Get POIActive value
     * @return bool
     */
    public function getPOIActive()
    {
        return $this->POIActive;
    }
    /**
     * Set POIActive value
     * @param bool $pOIActive
     * @return \StructType\POISelection
     */
    public function setPOIActive($pOIActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($pOIActive) && !is_bool($pOIActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pOIActive)), __LINE__);
        }
        $this->POIActive = $pOIActive;
        return $this;
    }
    /**
     * Get IncludeGroups value
     * @return bool
     */
    public function getIncludeGroups()
    {
        return $this->IncludeGroups;
    }
    /**
     * Set IncludeGroups value
     * @param bool $includeGroups
     * @return \StructType\POISelection
     */
    public function setIncludeGroups($includeGroups = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeGroups) && !is_bool($includeGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeGroups)), __LINE__);
        }
        $this->IncludeGroups = $includeGroups;
        return $this;
    }
    /**
     * Get IncludeContactPerson value
     * @return bool
     */
    public function getIncludeContactPerson()
    {
        return $this->IncludeContactPerson;
    }
    /**
     * Set IncludeContactPerson value
     * @param bool $includeContactPerson
     * @return \StructType\POISelection
     */
    public function setIncludeContactPerson($includeContactPerson = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeContactPerson) && !is_bool($includeContactPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeContactPerson)), __LINE__);
        }
        $this->IncludeContactPerson = $includeContactPerson;
        return $this;
    }
    /**
     * Get IncludeOpeningHours value
     * @return bool
     */
    public function getIncludeOpeningHours()
    {
        return $this->IncludeOpeningHours;
    }
    /**
     * Set IncludeOpeningHours value
     * @param bool $includeOpeningHours
     * @return \StructType\POISelection
     */
    public function setIncludeOpeningHours($includeOpeningHours = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeOpeningHours) && !is_bool($includeOpeningHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeOpeningHours)), __LINE__);
        }
        $this->IncludeOpeningHours = $includeOpeningHours;
        return $this;
    }
    /**
     * Get IncludeExtraInformation value
     * @return bool
     */
    public function getIncludeExtraInformation()
    {
        return $this->IncludeExtraInformation;
    }
    /**
     * Set IncludeExtraInformation value
     * @param bool $includeExtraInformation
     * @return \StructType\POISelection
     */
    public function setIncludeExtraInformation($includeExtraInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeExtraInformation) && !is_bool($includeExtraInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeExtraInformation)), __LINE__);
        }
        $this->IncludeExtraInformation = $includeExtraInformation;
        return $this;
    }
    /**
     * Get PoiIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getPoiIDs()
    {
        return $this->PoiIDs;
    }
    /**
     * Set PoiIDs value
     * @param \ArrayType\ArrayOfInt $poiIDs
     * @return \StructType\POISelection
     */
    public function setPoiIDs(\ArrayType\ArrayOfInt $poiIDs = null)
    {
        $this->PoiIDs = $poiIDs;
        return $this;
    }
    /**
     * Get PoiNames value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getPoiNames()
    {
        return $this->PoiNames;
    }
    /**
     * Set PoiNames value
     * @param \ArrayType\ArrayOfString $poiNames
     * @return \StructType\POISelection
     */
    public function setPoiNames(\ArrayType\ArrayOfString $poiNames = null)
    {
        $this->PoiNames = $poiNames;
        return $this;
    }
    /**
     * Get POIsNearPosition value
     * @return \StructType\PositionArea|null
     */
    public function getPOIsNearPosition()
    {
        return $this->POIsNearPosition;
    }
    /**
     * Set POIsNearPosition value
     * @param \StructType\PositionArea $pOIsNearPosition
     * @return \StructType\POISelection
     */
    public function setPOIsNearPosition(\StructType\PositionArea $pOIsNearPosition = null)
    {
        $this->POIsNearPosition = $pOIsNearPosition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\POISelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
