<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextStopResult_V2 StructType
 * @subpackage Structs
 */
class NextStopResult_V2 extends NextStopBase
{
    /**
     * The EstimatedTimeOfArrival
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EstimatedTimeOfArrival;
    /**
     * The CalculationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CalculationDate;
    /**
     * The RemainingSeconds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RemainingSeconds;
    /**
     * The RemainingKilometers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RemainingKilometers;
    /**
     * The HasAlarm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $HasAlarm;
    /**
     * The CreationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopCreationInfo
     */
    public $CreationInfo;
    /**
     * Constructor method for NextStopResult_V2
     * @uses NextStopResult_V2::setEstimatedTimeOfArrival()
     * @uses NextStopResult_V2::setCalculationDate()
     * @uses NextStopResult_V2::setRemainingSeconds()
     * @uses NextStopResult_V2::setRemainingKilometers()
     * @uses NextStopResult_V2::setHasAlarm()
     * @uses NextStopResult_V2::setCreationInfo()
     * @param string $estimatedTimeOfArrival
     * @param string $calculationDate
     * @param int $remainingSeconds
     * @param float $remainingKilometers
     * @param bool $hasAlarm
     * @param \StructType\NextStopCreationInfo $creationInfo
     */
    public function __construct($estimatedTimeOfArrival = null, $calculationDate = null, $remainingSeconds = null, $remainingKilometers = null, $hasAlarm = null, \StructType\NextStopCreationInfo $creationInfo = null)
    {
        $this
            ->setEstimatedTimeOfArrival($estimatedTimeOfArrival)
            ->setCalculationDate($calculationDate)
            ->setRemainingSeconds($remainingSeconds)
            ->setRemainingKilometers($remainingKilometers)
            ->setHasAlarm($hasAlarm)
            ->setCreationInfo($creationInfo);
    }
    /**
     * Get EstimatedTimeOfArrival value
     * @return string
     */
    public function getEstimatedTimeOfArrival()
    {
        return $this->EstimatedTimeOfArrival;
    }
    /**
     * Set EstimatedTimeOfArrival value
     * @param string $estimatedTimeOfArrival
     * @return \StructType\NextStopResult_V2
     */
    public function setEstimatedTimeOfArrival($estimatedTimeOfArrival = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedTimeOfArrival) && !is_string($estimatedTimeOfArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedTimeOfArrival)), __LINE__);
        }
        $this->EstimatedTimeOfArrival = $estimatedTimeOfArrival;
        return $this;
    }
    /**
     * Get CalculationDate value
     * @return string
     */
    public function getCalculationDate()
    {
        return $this->CalculationDate;
    }
    /**
     * Set CalculationDate value
     * @param string $calculationDate
     * @return \StructType\NextStopResult_V2
     */
    public function setCalculationDate($calculationDate = null)
    {
        // validation for constraint: string
        if (!is_null($calculationDate) && !is_string($calculationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calculationDate)), __LINE__);
        }
        $this->CalculationDate = $calculationDate;
        return $this;
    }
    /**
     * Get RemainingSeconds value
     * @return int
     */
    public function getRemainingSeconds()
    {
        return $this->RemainingSeconds;
    }
    /**
     * Set RemainingSeconds value
     * @param int $remainingSeconds
     * @return \StructType\NextStopResult_V2
     */
    public function setRemainingSeconds($remainingSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($remainingSeconds) && !is_numeric($remainingSeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($remainingSeconds)), __LINE__);
        }
        $this->RemainingSeconds = $remainingSeconds;
        return $this;
    }
    /**
     * Get RemainingKilometers value
     * @return float
     */
    public function getRemainingKilometers()
    {
        return $this->RemainingKilometers;
    }
    /**
     * Set RemainingKilometers value
     * @param float $remainingKilometers
     * @return \StructType\NextStopResult_V2
     */
    public function setRemainingKilometers($remainingKilometers = null)
    {
        $this->RemainingKilometers = $remainingKilometers;
        return $this;
    }
    /**
     * Get HasAlarm value
     * @return bool
     */
    public function getHasAlarm()
    {
        return $this->HasAlarm;
    }
    /**
     * Set HasAlarm value
     * @param bool $hasAlarm
     * @return \StructType\NextStopResult_V2
     */
    public function setHasAlarm($hasAlarm = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAlarm) && !is_bool($hasAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasAlarm)), __LINE__);
        }
        $this->HasAlarm = $hasAlarm;
        return $this;
    }
    /**
     * Get CreationInfo value
     * @return \StructType\NextStopCreationInfo|null
     */
    public function getCreationInfo()
    {
        return $this->CreationInfo;
    }
    /**
     * Set CreationInfo value
     * @param \StructType\NextStopCreationInfo $creationInfo
     * @return \StructType\NextStopResult_V2
     */
    public function setCreationInfo(\StructType\NextStopCreationInfo $creationInfo = null)
    {
        $this->CreationInfo = $creationInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NextStopResult_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
