<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextStopResult StructType
 * @subpackage Structs
 */
class NextStopResult extends NextStopBase
{
    /**
     * The EstimatedTimeOfArrival
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EstimatedTimeOfArrival;
    /**
     * The CalculationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CalculationDate;
    /**
     * The RemainingSeconds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RemainingSeconds;
    /**
     * The RemainingMeters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RemainingMeters;
    /**
     * The HasAlarm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $HasAlarm;
    /**
     * The CreationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopCreationInfo
     */
    public $CreationInfo;
    /**
     * The Place
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The Trip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * Constructor method for NextStopResult
     * @uses NextStopResult::setEstimatedTimeOfArrival()
     * @uses NextStopResult::setCalculationDate()
     * @uses NextStopResult::setRemainingSeconds()
     * @uses NextStopResult::setRemainingMeters()
     * @uses NextStopResult::setHasAlarm()
     * @uses NextStopResult::setCreationInfo()
     * @uses NextStopResult::setPlace()
     * @uses NextStopResult::setTrip()
     * @param string $estimatedTimeOfArrival
     * @param string $calculationDate
     * @param int $remainingSeconds
     * @param int $remainingMeters
     * @param bool $hasAlarm
     * @param \StructType\NextStopCreationInfo $creationInfo
     * @param \StructType\PlaceIdentifier $place
     * @param \StructType\TripIdentifier $trip
     */
    public function __construct($estimatedTimeOfArrival = null, $calculationDate = null, $remainingSeconds = null, $remainingMeters = null, $hasAlarm = null, \StructType\NextStopCreationInfo $creationInfo = null, \StructType\PlaceIdentifier $place = null, \StructType\TripIdentifier $trip = null)
    {
        $this
            ->setEstimatedTimeOfArrival($estimatedTimeOfArrival)
            ->setCalculationDate($calculationDate)
            ->setRemainingSeconds($remainingSeconds)
            ->setRemainingMeters($remainingMeters)
            ->setHasAlarm($hasAlarm)
            ->setCreationInfo($creationInfo)
            ->setPlace($place)
            ->setTrip($trip);
    }
    /**
     * Get EstimatedTimeOfArrival value
     * @return string
     */
    public function getEstimatedTimeOfArrival()
    {
        return $this->EstimatedTimeOfArrival;
    }
    /**
     * Set EstimatedTimeOfArrival value
     * @param string $estimatedTimeOfArrival
     * @return \StructType\NextStopResult
     */
    public function setEstimatedTimeOfArrival($estimatedTimeOfArrival = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedTimeOfArrival) && !is_string($estimatedTimeOfArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedTimeOfArrival)), __LINE__);
        }
        $this->EstimatedTimeOfArrival = $estimatedTimeOfArrival;
        return $this;
    }
    /**
     * Get CalculationDate value
     * @return string
     */
    public function getCalculationDate()
    {
        return $this->CalculationDate;
    }
    /**
     * Set CalculationDate value
     * @param string $calculationDate
     * @return \StructType\NextStopResult
     */
    public function setCalculationDate($calculationDate = null)
    {
        // validation for constraint: string
        if (!is_null($calculationDate) && !is_string($calculationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calculationDate)), __LINE__);
        }
        $this->CalculationDate = $calculationDate;
        return $this;
    }
    /**
     * Get RemainingSeconds value
     * @return int
     */
    public function getRemainingSeconds()
    {
        return $this->RemainingSeconds;
    }
    /**
     * Set RemainingSeconds value
     * @param int $remainingSeconds
     * @return \StructType\NextStopResult
     */
    public function setRemainingSeconds($remainingSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($remainingSeconds) && !is_numeric($remainingSeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($remainingSeconds)), __LINE__);
        }
        $this->RemainingSeconds = $remainingSeconds;
        return $this;
    }
    /**
     * Get RemainingMeters value
     * @return int
     */
    public function getRemainingMeters()
    {
        return $this->RemainingMeters;
    }
    /**
     * Set RemainingMeters value
     * @param int $remainingMeters
     * @return \StructType\NextStopResult
     */
    public function setRemainingMeters($remainingMeters = null)
    {
        // validation for constraint: int
        if (!is_null($remainingMeters) && !is_numeric($remainingMeters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($remainingMeters)), __LINE__);
        }
        $this->RemainingMeters = $remainingMeters;
        return $this;
    }
    /**
     * Get HasAlarm value
     * @return bool
     */
    public function getHasAlarm()
    {
        return $this->HasAlarm;
    }
    /**
     * Set HasAlarm value
     * @param bool $hasAlarm
     * @return \StructType\NextStopResult
     */
    public function setHasAlarm($hasAlarm = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAlarm) && !is_bool($hasAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasAlarm)), __LINE__);
        }
        $this->HasAlarm = $hasAlarm;
        return $this;
    }
    /**
     * Get CreationInfo value
     * @return \StructType\NextStopCreationInfo|null
     */
    public function getCreationInfo()
    {
        return $this->CreationInfo;
    }
    /**
     * Set CreationInfo value
     * @param \StructType\NextStopCreationInfo $creationInfo
     * @return \StructType\NextStopResult
     */
    public function setCreationInfo(\StructType\NextStopCreationInfo $creationInfo = null)
    {
        $this->CreationInfo = $creationInfo;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\NextStopResult
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\NextStopResult
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NextStopResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
