<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextStopCreationInfo StructType
 * @subpackage Structs
 */
class NextStopCreationInfo extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The CreatorSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreatorSource;
    /**
     * The Dispatcher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Dispatcher;
    /**
     * Constructor method for NextStopCreationInfo
     * @uses NextStopCreationInfo::setDate()
     * @uses NextStopCreationInfo::setCreatorSource()
     * @uses NextStopCreationInfo::setDispatcher()
     * @param string $date
     * @param string $creatorSource
     * @param \StructType\IdentifierPerson $dispatcher
     */
    public function __construct($date = null, $creatorSource = null, \StructType\IdentifierPerson $dispatcher = null)
    {
        $this
            ->setDate($date)
            ->setCreatorSource($creatorSource)
            ->setDispatcher($dispatcher);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\NextStopCreationInfo
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get CreatorSource value
     * @return string
     */
    public function getCreatorSource()
    {
        return $this->CreatorSource;
    }
    /**
     * Set CreatorSource value
     * @uses \EnumType\CreationSource::valueIsValid()
     * @uses \EnumType\CreationSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creatorSource
     * @return \StructType\NextStopCreationInfo
     */
    public function setCreatorSource($creatorSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreationSource::valueIsValid($creatorSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $creatorSource, implode(', ', \EnumType\CreationSource::getValidValues())), __LINE__);
        }
        $this->CreatorSource = $creatorSource;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\IdentifierPerson $dispatcher
     * @return \StructType\NextStopCreationInfo
     */
    public function setDispatcher(\StructType\IdentifierPerson $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NextStopCreationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
