<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModificationSelection StructType
 * @subpackage Structs
 */
class ModificationSelection extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The MaxAmountInReturn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxAmountInReturn;
    /**
     * Constructor method for ModificationSelection
     * @uses ModificationSelection::setId()
     * @uses ModificationSelection::setMaxAmountInReturn()
     * @param int $id
     * @param int $maxAmountInReturn
     */
    public function __construct($id = null, $maxAmountInReturn = null)
    {
        $this
            ->setId($id)
            ->setMaxAmountInReturn($maxAmountInReturn);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ModificationSelection
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MaxAmountInReturn value
     * @return int
     */
    public function getMaxAmountInReturn()
    {
        return $this->MaxAmountInReturn;
    }
    /**
     * Set MaxAmountInReturn value
     * @param int $maxAmountInReturn
     * @return \StructType\ModificationSelection
     */
    public function setMaxAmountInReturn($maxAmountInReturn = null)
    {
        // validation for constraint: int
        if (!is_null($maxAmountInReturn) && !is_numeric($maxAmountInReturn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxAmountInReturn)), __LINE__);
        }
        $this->MaxAmountInReturn = $maxAmountInReturn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModificationSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
