<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapViewParent StructType
 * @subpackage Structs
 */
class MapViewParent extends ExecutionResult
{
    /**
     * The MapBounds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Bounds
     */
    public $MapBounds;
    /**
     * The Map
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Map;
    /**
     * The MapClean
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MapClean;
    /**
     * Constructor method for MapViewParent
     * @uses MapViewParent::setMapBounds()
     * @uses MapViewParent::setMap()
     * @uses MapViewParent::setMapClean()
     * @param \StructType\Bounds $mapBounds
     * @param string $map
     * @param string $mapClean
     */
    public function __construct(\StructType\Bounds $mapBounds = null, $map = null, $mapClean = null)
    {
        $this
            ->setMapBounds($mapBounds)
            ->setMap($map)
            ->setMapClean($mapClean);
    }
    /**
     * Get MapBounds value
     * @return \StructType\Bounds|null
     */
    public function getMapBounds()
    {
        return $this->MapBounds;
    }
    /**
     * Set MapBounds value
     * @param \StructType\Bounds $mapBounds
     * @return \StructType\MapViewParent
     */
    public function setMapBounds(\StructType\Bounds $mapBounds = null)
    {
        $this->MapBounds = $mapBounds;
        return $this;
    }
    /**
     * Get Map value
     * @return string|null
     */
    public function getMap()
    {
        return $this->Map;
    }
    /**
     * Set Map value
     * @param string $map
     * @return \StructType\MapViewParent
     */
    public function setMap($map = null)
    {
        // validation for constraint: string
        if (!is_null($map) && !is_string($map)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($map)), __LINE__);
        }
        $this->Map = $map;
        return $this;
    }
    /**
     * Get MapClean value
     * @return string|null
     */
    public function getMapClean()
    {
        return $this->MapClean;
    }
    /**
     * Set MapClean value
     * @param string $mapClean
     * @return \StructType\MapViewParent
     */
    public function setMapClean($mapClean = null)
    {
        // validation for constraint: string
        if (!is_null($mapClean) && !is_string($mapClean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mapClean)), __LINE__);
        }
        $this->MapClean = $mapClean;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MapViewParent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
