<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapRoute StructType
 * @subpackage Structs
 */
class MapRoute extends AbstractStructBase
{
    /**
     * The RouteType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RouteType;
    /**
     * The Route
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $Route;
    /**
     * Constructor method for MapRoute
     * @uses MapRoute::setRouteType()
     * @uses MapRoute::setRoute()
     * @param string $routeType
     * @param mixed $route
     */
    public function __construct($routeType = null, $route = null)
    {
        $this
            ->setRouteType($routeType)
            ->setRoute($route);
    }
    /**
     * Get RouteType value
     * @return string|null
     */
    public function getRouteType()
    {
        return $this->RouteType;
    }
    /**
     * Set RouteType value
     * @param string $routeType
     * @return \StructType\MapRoute
     */
    public function setRouteType($routeType = null)
    {
        // validation for constraint: string
        if (!is_null($routeType) && !is_string($routeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeType)), __LINE__);
        }
        $this->RouteType = $routeType;
        return $this;
    }
    /**
     * Get Route value
     * @return mixed|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @param mixed $route
     * @return \StructType\MapRoute
     */
    public function setRoute($route = null)
    {
        $this->Route = $route;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MapRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
