<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapPosition StructType
 * @subpackage Structs
 */
class MapPosition extends Position
{
    /**
     * The PixelX
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PixelX;
    /**
     * The PixelY
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PixelY;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The MapItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMapItem
     */
    public $MapItems;
    /**
     * Constructor method for MapPosition
     * @uses MapPosition::setPixelX()
     * @uses MapPosition::setPixelY()
     * @uses MapPosition::setDate()
     * @uses MapPosition::setMapItems()
     * @param int $pixelX
     * @param int $pixelY
     * @param string $date
     * @param \ArrayType\ArrayOfMapItem $mapItems
     */
    public function __construct($pixelX = null, $pixelY = null, $date = null, \ArrayType\ArrayOfMapItem $mapItems = null)
    {
        $this
            ->setPixelX($pixelX)
            ->setPixelY($pixelY)
            ->setDate($date)
            ->setMapItems($mapItems);
    }
    /**
     * Get PixelX value
     * @return int
     */
    public function getPixelX()
    {
        return $this->PixelX;
    }
    /**
     * Set PixelX value
     * @param int $pixelX
     * @return \StructType\MapPosition
     */
    public function setPixelX($pixelX = null)
    {
        // validation for constraint: int
        if (!is_null($pixelX) && !is_numeric($pixelX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pixelX)), __LINE__);
        }
        $this->PixelX = $pixelX;
        return $this;
    }
    /**
     * Get PixelY value
     * @return int
     */
    public function getPixelY()
    {
        return $this->PixelY;
    }
    /**
     * Set PixelY value
     * @param int $pixelY
     * @return \StructType\MapPosition
     */
    public function setPixelY($pixelY = null)
    {
        // validation for constraint: int
        if (!is_null($pixelY) && !is_numeric($pixelY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pixelY)), __LINE__);
        }
        $this->PixelY = $pixelY;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\MapPosition
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get MapItems value
     * @return \ArrayType\ArrayOfMapItem|null
     */
    public function getMapItems()
    {
        return $this->MapItems;
    }
    /**
     * Set MapItems value
     * @param \ArrayType\ArrayOfMapItem $mapItems
     * @return \StructType\MapPosition
     */
    public function setMapItems(\ArrayType\ArrayOfMapItem $mapItems = null)
    {
        $this->MapItems = $mapItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MapPosition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
