<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapItem StructType
 * @subpackage Structs
 */
class MapItem extends AbstractStructBase
{
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * Constructor method for MapItem
     * @uses MapItem::setVehicle()
     * @uses MapItem::setTrailer()
     * @uses MapItem::setDriver()
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierPerson $driver
     */
    public function __construct(\StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierPerson $driver = null)
    {
        $this
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver);
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\MapItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\MapItem
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\MapItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MapItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
