<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MagellanTracerGeoZoneInfo StructType
 * @subpackage Structs
 */
class MagellanTracerGeoZoneInfo extends AbstractStructBase
{
    /**
     * The GeoZoneID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GeoZoneID;
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Radius;
    /**
     * The GeoZoneName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GeoZoneName;
    /**
     * The GeoZoneAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GeoZoneAddress;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * Constructor method for MagellanTracerGeoZoneInfo
     * @uses MagellanTracerGeoZoneInfo::setGeoZoneID()
     * @uses MagellanTracerGeoZoneInfo::setRadius()
     * @uses MagellanTracerGeoZoneInfo::setGeoZoneName()
     * @uses MagellanTracerGeoZoneInfo::setGeoZoneAddress()
     * @uses MagellanTracerGeoZoneInfo::setPosition()
     * @param int $geoZoneID
     * @param int $radius
     * @param string $geoZoneName
     * @param string $geoZoneAddress
     * @param \StructType\Position $position
     */
    public function __construct($geoZoneID = null, $radius = null, $geoZoneName = null, $geoZoneAddress = null, \StructType\Position $position = null)
    {
        $this
            ->setGeoZoneID($geoZoneID)
            ->setRadius($radius)
            ->setGeoZoneName($geoZoneName)
            ->setGeoZoneAddress($geoZoneAddress)
            ->setPosition($position);
    }
    /**
     * Get GeoZoneID value
     * @return int
     */
    public function getGeoZoneID()
    {
        return $this->GeoZoneID;
    }
    /**
     * Set GeoZoneID value
     * @param int $geoZoneID
     * @return \StructType\MagellanTracerGeoZoneInfo
     */
    public function setGeoZoneID($geoZoneID = null)
    {
        // validation for constraint: int
        if (!is_null($geoZoneID) && !is_numeric($geoZoneID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($geoZoneID)), __LINE__);
        }
        $this->GeoZoneID = $geoZoneID;
        return $this;
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\MagellanTracerGeoZoneInfo
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !is_numeric($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get GeoZoneName value
     * @return string|null
     */
    public function getGeoZoneName()
    {
        return $this->GeoZoneName;
    }
    /**
     * Set GeoZoneName value
     * @param string $geoZoneName
     * @return \StructType\MagellanTracerGeoZoneInfo
     */
    public function setGeoZoneName($geoZoneName = null)
    {
        // validation for constraint: string
        if (!is_null($geoZoneName) && !is_string($geoZoneName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geoZoneName)), __LINE__);
        }
        $this->GeoZoneName = $geoZoneName;
        return $this;
    }
    /**
     * Get GeoZoneAddress value
     * @return string|null
     */
    public function getGeoZoneAddress()
    {
        return $this->GeoZoneAddress;
    }
    /**
     * Set GeoZoneAddress value
     * @param string $geoZoneAddress
     * @return \StructType\MagellanTracerGeoZoneInfo
     */
    public function setGeoZoneAddress($geoZoneAddress = null)
    {
        // validation for constraint: string
        if (!is_null($geoZoneAddress) && !is_string($geoZoneAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geoZoneAddress)), __LINE__);
        }
        $this->GeoZoneAddress = $geoZoneAddress;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\MagellanTracerGeoZoneInfo
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MagellanTracerGeoZoneInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
