<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MagellanTracerAlarmInfo StructType
 * @subpackage Structs
 */
class MagellanTracerAlarmInfo extends AbstractStructBase
{
    /**
     * The AlarmDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AlarmDateTime;
    /**
     * The AlarmID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AlarmID;
    /**
     * The GeoZoneID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $GeoZoneID;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The AlarmKind
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlarmKind;
    /**
     * The AlarmMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlarmMessage;
    /**
     * Constructor method for MagellanTracerAlarmInfo
     * @uses MagellanTracerAlarmInfo::setAlarmDateTime()
     * @uses MagellanTracerAlarmInfo::setAlarmID()
     * @uses MagellanTracerAlarmInfo::setGeoZoneID()
     * @uses MagellanTracerAlarmInfo::setPosition()
     * @uses MagellanTracerAlarmInfo::setAlarmKind()
     * @uses MagellanTracerAlarmInfo::setAlarmMessage()
     * @param string $alarmDateTime
     * @param int $alarmID
     * @param int $geoZoneID
     * @param \StructType\Position $position
     * @param string $alarmKind
     * @param string $alarmMessage
     */
    public function __construct($alarmDateTime = null, $alarmID = null, $geoZoneID = null, \StructType\Position $position = null, $alarmKind = null, $alarmMessage = null)
    {
        $this
            ->setAlarmDateTime($alarmDateTime)
            ->setAlarmID($alarmID)
            ->setGeoZoneID($geoZoneID)
            ->setPosition($position)
            ->setAlarmKind($alarmKind)
            ->setAlarmMessage($alarmMessage);
    }
    /**
     * Get AlarmDateTime value
     * @return string
     */
    public function getAlarmDateTime()
    {
        return $this->AlarmDateTime;
    }
    /**
     * Set AlarmDateTime value
     * @param string $alarmDateTime
     * @return \StructType\MagellanTracerAlarmInfo
     */
    public function setAlarmDateTime($alarmDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($alarmDateTime) && !is_string($alarmDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alarmDateTime)), __LINE__);
        }
        $this->AlarmDateTime = $alarmDateTime;
        return $this;
    }
    /**
     * Get AlarmID value
     * @return int
     */
    public function getAlarmID()
    {
        return $this->AlarmID;
    }
    /**
     * Set AlarmID value
     * @param int $alarmID
     * @return \StructType\MagellanTracerAlarmInfo
     */
    public function setAlarmID($alarmID = null)
    {
        // validation for constraint: int
        if (!is_null($alarmID) && !is_numeric($alarmID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($alarmID)), __LINE__);
        }
        $this->AlarmID = $alarmID;
        return $this;
    }
    /**
     * Get GeoZoneID value
     * @return int
     */
    public function getGeoZoneID()
    {
        return $this->GeoZoneID;
    }
    /**
     * Set GeoZoneID value
     * @param int $geoZoneID
     * @return \StructType\MagellanTracerAlarmInfo
     */
    public function setGeoZoneID($geoZoneID = null)
    {
        // validation for constraint: int
        if (!is_null($geoZoneID) && !is_numeric($geoZoneID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($geoZoneID)), __LINE__);
        }
        $this->GeoZoneID = $geoZoneID;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\MagellanTracerAlarmInfo
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get AlarmKind value
     * @return string|null
     */
    public function getAlarmKind()
    {
        return $this->AlarmKind;
    }
    /**
     * Set AlarmKind value
     * @param string $alarmKind
     * @return \StructType\MagellanTracerAlarmInfo
     */
    public function setAlarmKind($alarmKind = null)
    {
        // validation for constraint: string
        if (!is_null($alarmKind) && !is_string($alarmKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alarmKind)), __LINE__);
        }
        $this->AlarmKind = $alarmKind;
        return $this;
    }
    /**
     * Get AlarmMessage value
     * @return string|null
     */
    public function getAlarmMessage()
    {
        return $this->AlarmMessage;
    }
    /**
     * Set AlarmMessage value
     * @param string $alarmMessage
     * @return \StructType\MagellanTracerAlarmInfo
     */
    public function setAlarmMessage($alarmMessage = null)
    {
        // validation for constraint: string
        if (!is_null($alarmMessage) && !is_string($alarmMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alarmMessage)), __LINE__);
        }
        $this->AlarmMessage = $alarmMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MagellanTracerAlarmInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
