<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MagellanDataSelection StructType
 * @subpackage Structs
 */
class MagellanDataSelection extends AbstractStructBase
{
    /**
     * The SinceIDSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SinceIDSelection;
    /**
     * The Tracer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MagellanTracerIdentifier
     */
    public $Tracer;
    /**
     * The DateTimeRangeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * Constructor method for MagellanDataSelection
     * @uses MagellanDataSelection::setSinceIDSelection()
     * @uses MagellanDataSelection::setTracer()
     * @uses MagellanDataSelection::setDateTimeRangeSelection()
     * @param int $sinceIDSelection
     * @param \StructType\MagellanTracerIdentifier $tracer
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     */
    public function __construct($sinceIDSelection = null, \StructType\MagellanTracerIdentifier $tracer = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this
            ->setSinceIDSelection($sinceIDSelection)
            ->setTracer($tracer)
            ->setDateTimeRangeSelection($dateTimeRangeSelection);
    }
    /**
     * Get SinceIDSelection value
     * @return int
     */
    public function getSinceIDSelection()
    {
        return $this->SinceIDSelection;
    }
    /**
     * Set SinceIDSelection value
     * @param int $sinceIDSelection
     * @return \StructType\MagellanDataSelection
     */
    public function setSinceIDSelection($sinceIDSelection = null)
    {
        // validation for constraint: int
        if (!is_null($sinceIDSelection) && !is_numeric($sinceIDSelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sinceIDSelection)), __LINE__);
        }
        $this->SinceIDSelection = $sinceIDSelection;
        return $this;
    }
    /**
     * Get Tracer value
     * @return \StructType\MagellanTracerIdentifier|null
     */
    public function getTracer()
    {
        return $this->Tracer;
    }
    /**
     * Set Tracer value
     * @param \StructType\MagellanTracerIdentifier $tracer
     * @return \StructType\MagellanDataSelection
     */
    public function setTracer(\StructType\MagellanTracerIdentifier $tracer = null)
    {
        $this->Tracer = $tracer;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\MagellanDataSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MagellanDataSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
