<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login StructType
 * @subpackage Structs
 */
class Login extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Version;
    /**
     * The SystemNr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemNr;
    /**
     * The Dispatcher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dispatcher;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The ApplicationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationName;
    /**
     * The ApplicationVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The PcName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PcName;
    /**
     * The Integrator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Integrator;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * Constructor method for Login
     * @uses Login::setDateTime()
     * @uses Login::setVersion()
     * @uses Login::setSystemNr()
     * @uses Login::setDispatcher()
     * @uses Login::setPassword()
     * @uses Login::setApplicationName()
     * @uses Login::setApplicationVersion()
     * @uses Login::setPcName()
     * @uses Login::setIntegrator()
     * @uses Login::setLanguage()
     * @param string $dateTime
     * @param int $version
     * @param int $systemNr
     * @param string $dispatcher
     * @param string $password
     * @param string $applicationName
     * @param string $applicationVersion
     * @param string $pcName
     * @param string $integrator
     * @param string $language
     */
    public function __construct($dateTime = null, $version = null, $systemNr = null, $dispatcher = null, $password = null, $applicationName = null, $applicationVersion = null, $pcName = null, $integrator = null, $language = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setVersion($version)
            ->setSystemNr($systemNr)
            ->setDispatcher($dispatcher)
            ->setPassword($password)
            ->setApplicationName($applicationName)
            ->setApplicationVersion($applicationVersion)
            ->setPcName($pcName)
            ->setIntegrator($integrator)
            ->setLanguage($language);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\Login
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Version value
     * @return int
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param int $version
     * @return \StructType\Login
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get SystemNr value
     * @return int
     */
    public function getSystemNr()
    {
        return $this->SystemNr;
    }
    /**
     * Set SystemNr value
     * @param int $systemNr
     * @return \StructType\Login
     */
    public function setSystemNr($systemNr = null)
    {
        // validation for constraint: int
        if (!is_null($systemNr) && !is_numeric($systemNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemNr)), __LINE__);
        }
        $this->SystemNr = $systemNr;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return string|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param string $dispatcher
     * @return \StructType\Login
     */
    public function setDispatcher($dispatcher = null)
    {
        // validation for constraint: string
        if (!is_null($dispatcher) && !is_string($dispatcher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dispatcher)), __LINE__);
        }
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Login
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get ApplicationName value
     * @return string|null
     */
    public function getApplicationName()
    {
        return $this->ApplicationName;
    }
    /**
     * Set ApplicationName value
     * @param string $applicationName
     * @return \StructType\Login
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationName)), __LINE__);
        }
        $this->ApplicationName = $applicationName;
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return $this->ApplicationVersion;
    }
    /**
     * Set ApplicationVersion value
     * @param string $applicationVersion
     * @return \StructType\Login
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationVersion)), __LINE__);
        }
        $this->ApplicationVersion = $applicationVersion;
        return $this;
    }
    /**
     * Get PcName value
     * @return string|null
     */
    public function getPcName()
    {
        return $this->PcName;
    }
    /**
     * Set PcName value
     * @param string $pcName
     * @return \StructType\Login
     */
    public function setPcName($pcName = null)
    {
        // validation for constraint: string
        if (!is_null($pcName) && !is_string($pcName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pcName)), __LINE__);
        }
        $this->PcName = $pcName;
        return $this;
    }
    /**
     * Get Integrator value
     * @return string|null
     */
    public function getIntegrator()
    {
        return $this->Integrator;
    }
    /**
     * Set Integrator value
     * @param string $integrator
     * @return \StructType\Login
     */
    public function setIntegrator($integrator = null)
    {
        // validation for constraint: string
        if (!is_null($integrator) && !is_string($integrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integrator)), __LINE__);
        }
        $this->Integrator = $integrator;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\Login
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Login
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
