<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobResultInsert StructType
 * @subpackage Structs
 */
class JobResultInsert extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Action;
    /**
     * The JobId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobId;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductResultInsert
     */
    public $Products;
    /**
     * Constructor method for JobResultInsert
     * @uses JobResultInsert::setAction()
     * @uses JobResultInsert::setJobId()
     * @uses JobResultInsert::setProducts()
     * @param string $action
     * @param string $jobId
     * @param \ArrayType\ArrayOfProductResultInsert $products
     */
    public function __construct($action = null, $jobId = null, \ArrayType\ArrayOfProductResultInsert $products = null)
    {
        $this
            ->setAction($action)
            ->setJobId($jobId)
            ->setProducts($products);
    }
    /**
     * Get Action value
     * @return string
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\EnumPlanningActionType::valueIsValid()
     * @uses \EnumType\EnumPlanningActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\JobResultInsert
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\EnumPlanningActionType::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get JobId value
     * @return string|null
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param string $jobId
     * @return \StructType\JobResultInsert
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: string
        if (!is_null($jobId) && !is_string($jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductResultInsert|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductResultInsert $products
     * @return \StructType\JobResultInsert
     */
    public function setProducts(\ArrayType\ArrayOfProductResultInsert $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JobResultInsert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
