<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobInsert StructType
 * @subpackage Structs
 */
class JobInsert extends Job
{
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductInsert
     */
    public $Products;
    /**
     * The PlanningConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningConfig
     */
    public $PlanningConfig;
    /**
     * Constructor method for JobInsert
     * @uses JobInsert::setProducts()
     * @uses JobInsert::setPlanningConfig()
     * @param \ArrayType\ArrayOfProductInsert $products
     * @param \StructType\PlanningConfig $planningConfig
     */
    public function __construct(\ArrayType\ArrayOfProductInsert $products = null, \StructType\PlanningConfig $planningConfig = null)
    {
        $this
            ->setProducts($products)
            ->setPlanningConfig($planningConfig);
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductInsert|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductInsert $products
     * @return \StructType\JobInsert
     */
    public function setProducts(\ArrayType\ArrayOfProductInsert $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get PlanningConfig value
     * @return \StructType\PlanningConfig|null
     */
    public function getPlanningConfig()
    {
        return $this->PlanningConfig;
    }
    /**
     * Set PlanningConfig value
     * @param \StructType\PlanningConfig $planningConfig
     * @return \StructType\JobInsert
     */
    public function setPlanningConfig(\StructType\PlanningConfig $planningConfig = null)
    {
        $this->PlanningConfig = $planningConfig;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JobInsert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
