<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceViaRouteResult_V3 StructType
 * @subpackage Structs
 */
class InterfaceViaRouteResult_V3 extends InterfaceViaRouteResult_V2
{
    /**
     * The ViaRouteBehavior
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ViaRouteBehavior;
    /**
     * Constructor method for InterfaceViaRouteResult_V3
     * @uses InterfaceViaRouteResult_V3::setViaRouteBehavior()
     * @param string $viaRouteBehavior
     */
    public function __construct($viaRouteBehavior = null)
    {
        $this
            ->setViaRouteBehavior($viaRouteBehavior);
    }
    /**
     * Get ViaRouteBehavior value
     * @return string
     */
    public function getViaRouteBehavior()
    {
        return $this->ViaRouteBehavior;
    }
    /**
     * Set ViaRouteBehavior value
     * @uses \EnumType\EnumViaRouteBehavior::valueIsValid()
     * @uses \EnumType\EnumViaRouteBehavior::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viaRouteBehavior
     * @return \StructType\InterfaceViaRouteResult_V3
     */
    public function setViaRouteBehavior($viaRouteBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRouteBehavior::valueIsValid($viaRouteBehavior)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $viaRouteBehavior, implode(', ', \EnumType\EnumViaRouteBehavior::getValidValues())), __LINE__);
        }
        $this->ViaRouteBehavior = $viaRouteBehavior;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InterfaceViaRouteResult_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
