<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceVehicleResult_V7 StructType
 * @subpackage Structs
 */
class InterfaceVehicleResult_V7 extends Vehicle_V2
{
    /**
     * The VehicleTransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VehicleTransicsID;
    /**
     * The Modified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The CurrentKms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurrentKms;
    /**
     * The FuelLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevel;
    /**
     * The FuelLevelIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevelIndex;
    /**
     * The RefrigeratorIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RefrigeratorIndex;
    /**
     * The ActivityCompleted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ActivityCompleted;
    /**
     * The Maintenance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Maintenance;
    /**
     * The Remaining
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Remaining;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Category;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierTrailerResult
     */
    public $Trailer;
    /**
     * The VehicleProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleProfileResult
     */
    public $VehicleProfile;
    /**
     * The LastTrailerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastTrailerCode;
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierResult
     */
    public $Site;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * The ObcInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleObcInfo
     */
    public $ObcInfo;
    /**
     * The ETAInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleETAInfo
     */
    public $ETAInfo;
    /**
     * The TemperatureInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleTemperatureInfo_V2
     */
    public $TemperatureInfo;
    /**
     * The InfoFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleInfoFields
     */
    public $InfoFields;
    /**
     * The UpdateDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleUpdateDates
     */
    public $UpdateDates;
    /**
     * The VehicleCostInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleCostInfo
     */
    public $VehicleCostInfo;
    /**
     * The NextStopInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopResult
     */
    public $NextStopInfo;
    /**
     * The FormattedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * The GSMNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GSMNumber;
    /**
     * The HomebaseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomebaseNumber;
    /**
     * The VehicleGeneralDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleGeneralDiagnostics
     */
    public $VehicleGeneralDiagnostics;
    /**
     * The VehicleCANDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleCANDiagnostics
     */
    public $VehicleCANDiagnostics;
    /**
     * The VehicleCommunicationDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleCommunicationDiagnostics
     */
    public $VehicleCommunicationDiagnostics;
    /**
     * The VehicleConfigurationDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleConfigurationDiagnostics
     */
    public $VehicleConfigurationDiagnostics;
    /**
     * The VehicleDigiDownloadDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleDigiDownloadDiagnostics
     */
    public $VehicleDigiDownloadDiagnostics;
    /**
     * The VehicleDocScanDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleDocScanDiagnostics
     */
    public $VehicleDocScanDiagnostics;
    /**
     * The VehicleEcoDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleEcoDiagnostics
     */
    public $VehicleEcoDiagnostics;
    /**
     * The VehicleEngineDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleEngineDiagnostics
     */
    public $VehicleEngineDiagnostics;
    /**
     * The VehicleGPRSDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleGPRSDiagnostics
     */
    public $VehicleGPRSDiagnostics;
    /**
     * The VehicleHardwareDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleHardwareDiagnostics
     */
    public $VehicleHardwareDiagnostics;
    /**
     * The VehicleIdentificationDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleIdentificationDiagnostics
     */
    public $VehicleIdentificationDiagnostics;
    /**
     * The VehicleMapDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleMapDiagnostics
     */
    public $VehicleMapDiagnostics;
    /**
     * The VehiclePositionDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehiclePositionDiagnostics
     */
    public $VehiclePositionDiagnostics;
    /**
     * The VehicleTachoDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleTachoDiagnostics
     */
    public $VehicleTachoDiagnostics;
    /**
     * The VehicleTimeDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleTimeDiagnostics
     */
    public $VehicleTimeDiagnostics;
    /**
     * The VehicleStateDiagnostics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleStateDiagnostics
     */
    public $VehicleStateDiagnostics;
    /**
     * The LastTextMessageInbox
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceTextMessageResult
     */
    public $LastTextMessageInbox;
    /**
     * The LastTextMessageOutbox
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceTextMessageResult
     */
    public $LastTextMessageOutbox;
    /**
     * The LastAlarmMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceAlarmMessageResult
     */
    public $LastAlarmMessage;
    /**
     * The BlockedVehicleInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceBlockedVehicleResult
     */
    public $BlockedVehicleInfo;
    /**
     * The AutoFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutoFilter;
    /**
     * The CompanyCardInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleCompanyCard
     */
    public $CompanyCardInfo;
    /**
     * Constructor method for InterfaceVehicleResult_V7
     * @uses InterfaceVehicleResult_V7::setVehicleTransicsID()
     * @uses InterfaceVehicleResult_V7::setModified()
     * @uses InterfaceVehicleResult_V7::setCurrentKms()
     * @uses InterfaceVehicleResult_V7::setFuelLevel()
     * @uses InterfaceVehicleResult_V7::setFuelLevelIndex()
     * @uses InterfaceVehicleResult_V7::setRefrigeratorIndex()
     * @uses InterfaceVehicleResult_V7::setActivityCompleted()
     * @uses InterfaceVehicleResult_V7::setMaintenance()
     * @uses InterfaceVehicleResult_V7::setRemaining()
     * @uses InterfaceVehicleResult_V7::setCategory()
     * @uses InterfaceVehicleResult_V7::setTrailer()
     * @uses InterfaceVehicleResult_V7::setVehicleProfile()
     * @uses InterfaceVehicleResult_V7::setLastTrailerCode()
     * @uses InterfaceVehicleResult_V7::setSite()
     * @uses InterfaceVehicleResult_V7::setPosition()
     * @uses InterfaceVehicleResult_V7::setActivity()
     * @uses InterfaceVehicleResult_V7::setDriver()
     * @uses InterfaceVehicleResult_V7::setCoDriver()
     * @uses InterfaceVehicleResult_V7::setObcInfo()
     * @uses InterfaceVehicleResult_V7::setETAInfo()
     * @uses InterfaceVehicleResult_V7::setTemperatureInfo()
     * @uses InterfaceVehicleResult_V7::setInfoFields()
     * @uses InterfaceVehicleResult_V7::setUpdateDates()
     * @uses InterfaceVehicleResult_V7::setVehicleCostInfo()
     * @uses InterfaceVehicleResult_V7::setNextStopInfo()
     * @uses InterfaceVehicleResult_V7::setFormattedName()
     * @uses InterfaceVehicleResult_V7::setGSMNumber()
     * @uses InterfaceVehicleResult_V7::setHomebaseNumber()
     * @uses InterfaceVehicleResult_V7::setVehicleGeneralDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleCANDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleCommunicationDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleConfigurationDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleDigiDownloadDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleDocScanDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleEcoDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleEngineDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleGPRSDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleHardwareDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleIdentificationDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleMapDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehiclePositionDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleTachoDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleTimeDiagnostics()
     * @uses InterfaceVehicleResult_V7::setVehicleStateDiagnostics()
     * @uses InterfaceVehicleResult_V7::setLastTextMessageInbox()
     * @uses InterfaceVehicleResult_V7::setLastTextMessageOutbox()
     * @uses InterfaceVehicleResult_V7::setLastAlarmMessage()
     * @uses InterfaceVehicleResult_V7::setBlockedVehicleInfo()
     * @uses InterfaceVehicleResult_V7::setAutoFilter()
     * @uses InterfaceVehicleResult_V7::setCompanyCardInfo()
     * @param int $vehicleTransicsID
     * @param string $modified
     * @param int $currentKms
     * @param int $fuelLevel
     * @param int $fuelLevelIndex
     * @param int $refrigeratorIndex
     * @param bool $activityCompleted
     * @param int $maintenance
     * @param int $remaining
     * @param string $category
     * @param \StructType\IdentifierTrailerResult $trailer
     * @param \StructType\VehicleProfileResult $vehicleProfile
     * @param string $lastTrailerCode
     * @param \StructType\IdentifierResult $site
     * @param \StructType\PositionResult $position
     * @param \StructType\Activity $activity
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @param \StructType\VehicleObcInfo $obcInfo
     * @param \StructType\VehicleETAInfo $eTAInfo
     * @param \StructType\VehicleTemperatureInfo_V2 $temperatureInfo
     * @param \StructType\VehicleInfoFields $infoFields
     * @param \StructType\VehicleUpdateDates $updateDates
     * @param \StructType\VehicleCostInfo $vehicleCostInfo
     * @param \StructType\NextStopResult $nextStopInfo
     * @param string $formattedName
     * @param string $gSMNumber
     * @param string $homebaseNumber
     * @param \StructType\VehicleGeneralDiagnostics $vehicleGeneralDiagnostics
     * @param \StructType\VehicleCANDiagnostics $vehicleCANDiagnostics
     * @param \StructType\VehicleCommunicationDiagnostics $vehicleCommunicationDiagnostics
     * @param \StructType\VehicleConfigurationDiagnostics $vehicleConfigurationDiagnostics
     * @param \StructType\VehicleDigiDownloadDiagnostics $vehicleDigiDownloadDiagnostics
     * @param \StructType\VehicleDocScanDiagnostics $vehicleDocScanDiagnostics
     * @param \StructType\VehicleEcoDiagnostics $vehicleEcoDiagnostics
     * @param \StructType\VehicleEngineDiagnostics $vehicleEngineDiagnostics
     * @param \StructType\VehicleGPRSDiagnostics $vehicleGPRSDiagnostics
     * @param \StructType\VehicleHardwareDiagnostics $vehicleHardwareDiagnostics
     * @param \StructType\VehicleIdentificationDiagnostics $vehicleIdentificationDiagnostics
     * @param \StructType\VehicleMapDiagnostics $vehicleMapDiagnostics
     * @param \StructType\VehiclePositionDiagnostics $vehiclePositionDiagnostics
     * @param \StructType\VehicleTachoDiagnostics $vehicleTachoDiagnostics
     * @param \StructType\VehicleTimeDiagnostics $vehicleTimeDiagnostics
     * @param \StructType\VehicleStateDiagnostics $vehicleStateDiagnostics
     * @param \StructType\InterfaceTextMessageResult $lastTextMessageInbox
     * @param \StructType\InterfaceTextMessageResult $lastTextMessageOutbox
     * @param \StructType\InterfaceAlarmMessageResult $lastAlarmMessage
     * @param \StructType\InterfaceBlockedVehicleResult $blockedVehicleInfo
     * @param string $autoFilter
     * @param \StructType\VehicleCompanyCard $companyCardInfo
     */
    public function __construct($vehicleTransicsID = null, $modified = null, $currentKms = null, $fuelLevel = null, $fuelLevelIndex = null, $refrigeratorIndex = null, $activityCompleted = null, $maintenance = null, $remaining = null, $category = null, \StructType\IdentifierTrailerResult $trailer = null, \StructType\VehicleProfileResult $vehicleProfile = null, $lastTrailerCode = null, \StructType\IdentifierResult $site = null, \StructType\PositionResult $position = null, \StructType\Activity $activity = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $coDriver = null, \StructType\VehicleObcInfo $obcInfo = null, \StructType\VehicleETAInfo $eTAInfo = null, \StructType\VehicleTemperatureInfo_V2 $temperatureInfo = null, \StructType\VehicleInfoFields $infoFields = null, \StructType\VehicleUpdateDates $updateDates = null, \StructType\VehicleCostInfo $vehicleCostInfo = null, \StructType\NextStopResult $nextStopInfo = null, $formattedName = null, $gSMNumber = null, $homebaseNumber = null, \StructType\VehicleGeneralDiagnostics $vehicleGeneralDiagnostics = null, \StructType\VehicleCANDiagnostics $vehicleCANDiagnostics = null, \StructType\VehicleCommunicationDiagnostics $vehicleCommunicationDiagnostics = null, \StructType\VehicleConfigurationDiagnostics $vehicleConfigurationDiagnostics = null, \StructType\VehicleDigiDownloadDiagnostics $vehicleDigiDownloadDiagnostics = null, \StructType\VehicleDocScanDiagnostics $vehicleDocScanDiagnostics = null, \StructType\VehicleEcoDiagnostics $vehicleEcoDiagnostics = null, \StructType\VehicleEngineDiagnostics $vehicleEngineDiagnostics = null, \StructType\VehicleGPRSDiagnostics $vehicleGPRSDiagnostics = null, \StructType\VehicleHardwareDiagnostics $vehicleHardwareDiagnostics = null, \StructType\VehicleIdentificationDiagnostics $vehicleIdentificationDiagnostics = null, \StructType\VehicleMapDiagnostics $vehicleMapDiagnostics = null, \StructType\VehiclePositionDiagnostics $vehiclePositionDiagnostics = null, \StructType\VehicleTachoDiagnostics $vehicleTachoDiagnostics = null, \StructType\VehicleTimeDiagnostics $vehicleTimeDiagnostics = null, \StructType\VehicleStateDiagnostics $vehicleStateDiagnostics = null, \StructType\InterfaceTextMessageResult $lastTextMessageInbox = null, \StructType\InterfaceTextMessageResult $lastTextMessageOutbox = null, \StructType\InterfaceAlarmMessageResult $lastAlarmMessage = null, \StructType\InterfaceBlockedVehicleResult $blockedVehicleInfo = null, $autoFilter = null, \StructType\VehicleCompanyCard $companyCardInfo = null)
    {
        $this
            ->setVehicleTransicsID($vehicleTransicsID)
            ->setModified($modified)
            ->setCurrentKms($currentKms)
            ->setFuelLevel($fuelLevel)
            ->setFuelLevelIndex($fuelLevelIndex)
            ->setRefrigeratorIndex($refrigeratorIndex)
            ->setActivityCompleted($activityCompleted)
            ->setMaintenance($maintenance)
            ->setRemaining($remaining)
            ->setCategory($category)
            ->setTrailer($trailer)
            ->setVehicleProfile($vehicleProfile)
            ->setLastTrailerCode($lastTrailerCode)
            ->setSite($site)
            ->setPosition($position)
            ->setActivity($activity)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setObcInfo($obcInfo)
            ->setETAInfo($eTAInfo)
            ->setTemperatureInfo($temperatureInfo)
            ->setInfoFields($infoFields)
            ->setUpdateDates($updateDates)
            ->setVehicleCostInfo($vehicleCostInfo)
            ->setNextStopInfo($nextStopInfo)
            ->setFormattedName($formattedName)
            ->setGSMNumber($gSMNumber)
            ->setHomebaseNumber($homebaseNumber)
            ->setVehicleGeneralDiagnostics($vehicleGeneralDiagnostics)
            ->setVehicleCANDiagnostics($vehicleCANDiagnostics)
            ->setVehicleCommunicationDiagnostics($vehicleCommunicationDiagnostics)
            ->setVehicleConfigurationDiagnostics($vehicleConfigurationDiagnostics)
            ->setVehicleDigiDownloadDiagnostics($vehicleDigiDownloadDiagnostics)
            ->setVehicleDocScanDiagnostics($vehicleDocScanDiagnostics)
            ->setVehicleEcoDiagnostics($vehicleEcoDiagnostics)
            ->setVehicleEngineDiagnostics($vehicleEngineDiagnostics)
            ->setVehicleGPRSDiagnostics($vehicleGPRSDiagnostics)
            ->setVehicleHardwareDiagnostics($vehicleHardwareDiagnostics)
            ->setVehicleIdentificationDiagnostics($vehicleIdentificationDiagnostics)
            ->setVehicleMapDiagnostics($vehicleMapDiagnostics)
            ->setVehiclePositionDiagnostics($vehiclePositionDiagnostics)
            ->setVehicleTachoDiagnostics($vehicleTachoDiagnostics)
            ->setVehicleTimeDiagnostics($vehicleTimeDiagnostics)
            ->setVehicleStateDiagnostics($vehicleStateDiagnostics)
            ->setLastTextMessageInbox($lastTextMessageInbox)
            ->setLastTextMessageOutbox($lastTextMessageOutbox)
            ->setLastAlarmMessage($lastAlarmMessage)
            ->setBlockedVehicleInfo($blockedVehicleInfo)
            ->setAutoFilter($autoFilter)
            ->setCompanyCardInfo($companyCardInfo);
    }
    /**
     * Get VehicleTransicsID value
     * @return int
     */
    public function getVehicleTransicsID()
    {
        return $this->VehicleTransicsID;
    }
    /**
     * Set VehicleTransicsID value
     * @param int $vehicleTransicsID
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleTransicsID($vehicleTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleTransicsID) && !is_numeric($vehicleTransicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vehicleTransicsID)), __LINE__);
        }
        $this->VehicleTransicsID = $vehicleTransicsID;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get CurrentKms value
     * @return int
     */
    public function getCurrentKms()
    {
        return $this->CurrentKms;
    }
    /**
     * Set CurrentKms value
     * @param int $currentKms
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setCurrentKms($currentKms = null)
    {
        // validation for constraint: int
        if (!is_null($currentKms) && !is_numeric($currentKms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentKms)), __LINE__);
        }
        $this->CurrentKms = $currentKms;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !is_numeric($fuelLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get FuelLevelIndex value
     * @return int
     */
    public function getFuelLevelIndex()
    {
        return $this->FuelLevelIndex;
    }
    /**
     * Set FuelLevelIndex value
     * @param int $fuelLevelIndex
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setFuelLevelIndex($fuelLevelIndex = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevelIndex) && !is_numeric($fuelLevelIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelLevelIndex)), __LINE__);
        }
        $this->FuelLevelIndex = $fuelLevelIndex;
        return $this;
    }
    /**
     * Get RefrigeratorIndex value
     * @return int
     */
    public function getRefrigeratorIndex()
    {
        return $this->RefrigeratorIndex;
    }
    /**
     * Set RefrigeratorIndex value
     * @param int $refrigeratorIndex
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setRefrigeratorIndex($refrigeratorIndex = null)
    {
        // validation for constraint: int
        if (!is_null($refrigeratorIndex) && !is_numeric($refrigeratorIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($refrigeratorIndex)), __LINE__);
        }
        $this->RefrigeratorIndex = $refrigeratorIndex;
        return $this;
    }
    /**
     * Get ActivityCompleted value
     * @return bool
     */
    public function getActivityCompleted()
    {
        return $this->ActivityCompleted;
    }
    /**
     * Set ActivityCompleted value
     * @param bool $activityCompleted
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setActivityCompleted($activityCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($activityCompleted) && !is_bool($activityCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($activityCompleted)), __LINE__);
        }
        $this->ActivityCompleted = $activityCompleted;
        return $this;
    }
    /**
     * Get Maintenance value
     * @return int
     */
    public function getMaintenance()
    {
        return $this->Maintenance;
    }
    /**
     * Set Maintenance value
     * @param int $maintenance
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setMaintenance($maintenance = null)
    {
        // validation for constraint: int
        if (!is_null($maintenance) && !is_numeric($maintenance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maintenance)), __LINE__);
        }
        $this->Maintenance = $maintenance;
        return $this;
    }
    /**
     * Get Remaining value
     * @return int
     */
    public function getRemaining()
    {
        return $this->Remaining;
    }
    /**
     * Set Remaining value
     * @param int $remaining
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setRemaining($remaining = null)
    {
        // validation for constraint: int
        if (!is_null($remaining) && !is_numeric($remaining)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($remaining)), __LINE__);
        }
        $this->Remaining = $remaining;
        return $this;
    }
    /**
     * Get Category value
     * @return string
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @uses \EnumType\VehicleCategory::valueIsValid()
     * @uses \EnumType\VehicleCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleCategory::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $category, implode(', ', \EnumType\VehicleCategory::getValidValues())), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierTrailerResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierTrailerResult $trailer
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setTrailer(\StructType\IdentifierTrailerResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get VehicleProfile value
     * @return \StructType\VehicleProfileResult|null
     */
    public function getVehicleProfile()
    {
        return $this->VehicleProfile;
    }
    /**
     * Set VehicleProfile value
     * @param \StructType\VehicleProfileResult $vehicleProfile
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleProfile(\StructType\VehicleProfileResult $vehicleProfile = null)
    {
        $this->VehicleProfile = $vehicleProfile;
        return $this;
    }
    /**
     * Get LastTrailerCode value
     * @return string|null
     */
    public function getLastTrailerCode()
    {
        return $this->LastTrailerCode;
    }
    /**
     * Set LastTrailerCode value
     * @param string $lastTrailerCode
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setLastTrailerCode($lastTrailerCode = null)
    {
        // validation for constraint: string
        if (!is_null($lastTrailerCode) && !is_string($lastTrailerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastTrailerCode)), __LINE__);
        }
        $this->LastTrailerCode = $lastTrailerCode;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierResult|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierResult $site
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setSite(\StructType\IdentifierResult $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get ObcInfo value
     * @return \StructType\VehicleObcInfo|null
     */
    public function getObcInfo()
    {
        return $this->ObcInfo;
    }
    /**
     * Set ObcInfo value
     * @param \StructType\VehicleObcInfo $obcInfo
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setObcInfo(\StructType\VehicleObcInfo $obcInfo = null)
    {
        $this->ObcInfo = $obcInfo;
        return $this;
    }
    /**
     * Get ETAInfo value
     * @return \StructType\VehicleETAInfo|null
     */
    public function getETAInfo()
    {
        return $this->ETAInfo;
    }
    /**
     * Set ETAInfo value
     * @param \StructType\VehicleETAInfo $eTAInfo
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setETAInfo(\StructType\VehicleETAInfo $eTAInfo = null)
    {
        $this->ETAInfo = $eTAInfo;
        return $this;
    }
    /**
     * Get TemperatureInfo value
     * @return \StructType\VehicleTemperatureInfo_V2|null
     */
    public function getTemperatureInfo()
    {
        return $this->TemperatureInfo;
    }
    /**
     * Set TemperatureInfo value
     * @param \StructType\VehicleTemperatureInfo_V2 $temperatureInfo
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setTemperatureInfo(\StructType\VehicleTemperatureInfo_V2 $temperatureInfo = null)
    {
        $this->TemperatureInfo = $temperatureInfo;
        return $this;
    }
    /**
     * Get InfoFields value
     * @return \StructType\VehicleInfoFields|null
     */
    public function getInfoFields()
    {
        return $this->InfoFields;
    }
    /**
     * Set InfoFields value
     * @param \StructType\VehicleInfoFields $infoFields
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setInfoFields(\StructType\VehicleInfoFields $infoFields = null)
    {
        $this->InfoFields = $infoFields;
        return $this;
    }
    /**
     * Get UpdateDates value
     * @return \StructType\VehicleUpdateDates|null
     */
    public function getUpdateDates()
    {
        return $this->UpdateDates;
    }
    /**
     * Set UpdateDates value
     * @param \StructType\VehicleUpdateDates $updateDates
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setUpdateDates(\StructType\VehicleUpdateDates $updateDates = null)
    {
        $this->UpdateDates = $updateDates;
        return $this;
    }
    /**
     * Get VehicleCostInfo value
     * @return \StructType\VehicleCostInfo|null
     */
    public function getVehicleCostInfo()
    {
        return $this->VehicleCostInfo;
    }
    /**
     * Set VehicleCostInfo value
     * @param \StructType\VehicleCostInfo $vehicleCostInfo
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleCostInfo(\StructType\VehicleCostInfo $vehicleCostInfo = null)
    {
        $this->VehicleCostInfo = $vehicleCostInfo;
        return $this;
    }
    /**
     * Get NextStopInfo value
     * @return \StructType\NextStopResult|null
     */
    public function getNextStopInfo()
    {
        return $this->NextStopInfo;
    }
    /**
     * Set NextStopInfo value
     * @param \StructType\NextStopResult $nextStopInfo
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setNextStopInfo(\StructType\NextStopResult $nextStopInfo = null)
    {
        $this->NextStopInfo = $nextStopInfo;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
    /**
     * Get GSMNumber value
     * @return string|null
     */
    public function getGSMNumber()
    {
        return $this->GSMNumber;
    }
    /**
     * Set GSMNumber value
     * @param string $gSMNumber
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setGSMNumber($gSMNumber = null)
    {
        // validation for constraint: string
        if (!is_null($gSMNumber) && !is_string($gSMNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gSMNumber)), __LINE__);
        }
        $this->GSMNumber = $gSMNumber;
        return $this;
    }
    /**
     * Get HomebaseNumber value
     * @return string|null
     */
    public function getHomebaseNumber()
    {
        return $this->HomebaseNumber;
    }
    /**
     * Set HomebaseNumber value
     * @param string $homebaseNumber
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setHomebaseNumber($homebaseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($homebaseNumber) && !is_string($homebaseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homebaseNumber)), __LINE__);
        }
        $this->HomebaseNumber = $homebaseNumber;
        return $this;
    }
    /**
     * Get VehicleGeneralDiagnostics value
     * @return \StructType\VehicleGeneralDiagnostics|null
     */
    public function getVehicleGeneralDiagnostics()
    {
        return $this->VehicleGeneralDiagnostics;
    }
    /**
     * Set VehicleGeneralDiagnostics value
     * @param \StructType\VehicleGeneralDiagnostics $vehicleGeneralDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleGeneralDiagnostics(\StructType\VehicleGeneralDiagnostics $vehicleGeneralDiagnostics = null)
    {
        $this->VehicleGeneralDiagnostics = $vehicleGeneralDiagnostics;
        return $this;
    }
    /**
     * Get VehicleCANDiagnostics value
     * @return \StructType\VehicleCANDiagnostics|null
     */
    public function getVehicleCANDiagnostics()
    {
        return $this->VehicleCANDiagnostics;
    }
    /**
     * Set VehicleCANDiagnostics value
     * @param \StructType\VehicleCANDiagnostics $vehicleCANDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleCANDiagnostics(\StructType\VehicleCANDiagnostics $vehicleCANDiagnostics = null)
    {
        $this->VehicleCANDiagnostics = $vehicleCANDiagnostics;
        return $this;
    }
    /**
     * Get VehicleCommunicationDiagnostics value
     * @return \StructType\VehicleCommunicationDiagnostics|null
     */
    public function getVehicleCommunicationDiagnostics()
    {
        return $this->VehicleCommunicationDiagnostics;
    }
    /**
     * Set VehicleCommunicationDiagnostics value
     * @param \StructType\VehicleCommunicationDiagnostics $vehicleCommunicationDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleCommunicationDiagnostics(\StructType\VehicleCommunicationDiagnostics $vehicleCommunicationDiagnostics = null)
    {
        $this->VehicleCommunicationDiagnostics = $vehicleCommunicationDiagnostics;
        return $this;
    }
    /**
     * Get VehicleConfigurationDiagnostics value
     * @return \StructType\VehicleConfigurationDiagnostics|null
     */
    public function getVehicleConfigurationDiagnostics()
    {
        return $this->VehicleConfigurationDiagnostics;
    }
    /**
     * Set VehicleConfigurationDiagnostics value
     * @param \StructType\VehicleConfigurationDiagnostics $vehicleConfigurationDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleConfigurationDiagnostics(\StructType\VehicleConfigurationDiagnostics $vehicleConfigurationDiagnostics = null)
    {
        $this->VehicleConfigurationDiagnostics = $vehicleConfigurationDiagnostics;
        return $this;
    }
    /**
     * Get VehicleDigiDownloadDiagnostics value
     * @return \StructType\VehicleDigiDownloadDiagnostics|null
     */
    public function getVehicleDigiDownloadDiagnostics()
    {
        return $this->VehicleDigiDownloadDiagnostics;
    }
    /**
     * Set VehicleDigiDownloadDiagnostics value
     * @param \StructType\VehicleDigiDownloadDiagnostics $vehicleDigiDownloadDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleDigiDownloadDiagnostics(\StructType\VehicleDigiDownloadDiagnostics $vehicleDigiDownloadDiagnostics = null)
    {
        $this->VehicleDigiDownloadDiagnostics = $vehicleDigiDownloadDiagnostics;
        return $this;
    }
    /**
     * Get VehicleDocScanDiagnostics value
     * @return \StructType\VehicleDocScanDiagnostics|null
     */
    public function getVehicleDocScanDiagnostics()
    {
        return $this->VehicleDocScanDiagnostics;
    }
    /**
     * Set VehicleDocScanDiagnostics value
     * @param \StructType\VehicleDocScanDiagnostics $vehicleDocScanDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleDocScanDiagnostics(\StructType\VehicleDocScanDiagnostics $vehicleDocScanDiagnostics = null)
    {
        $this->VehicleDocScanDiagnostics = $vehicleDocScanDiagnostics;
        return $this;
    }
    /**
     * Get VehicleEcoDiagnostics value
     * @return \StructType\VehicleEcoDiagnostics|null
     */
    public function getVehicleEcoDiagnostics()
    {
        return $this->VehicleEcoDiagnostics;
    }
    /**
     * Set VehicleEcoDiagnostics value
     * @param \StructType\VehicleEcoDiagnostics $vehicleEcoDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleEcoDiagnostics(\StructType\VehicleEcoDiagnostics $vehicleEcoDiagnostics = null)
    {
        $this->VehicleEcoDiagnostics = $vehicleEcoDiagnostics;
        return $this;
    }
    /**
     * Get VehicleEngineDiagnostics value
     * @return \StructType\VehicleEngineDiagnostics|null
     */
    public function getVehicleEngineDiagnostics()
    {
        return $this->VehicleEngineDiagnostics;
    }
    /**
     * Set VehicleEngineDiagnostics value
     * @param \StructType\VehicleEngineDiagnostics $vehicleEngineDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleEngineDiagnostics(\StructType\VehicleEngineDiagnostics $vehicleEngineDiagnostics = null)
    {
        $this->VehicleEngineDiagnostics = $vehicleEngineDiagnostics;
        return $this;
    }
    /**
     * Get VehicleGPRSDiagnostics value
     * @return \StructType\VehicleGPRSDiagnostics|null
     */
    public function getVehicleGPRSDiagnostics()
    {
        return $this->VehicleGPRSDiagnostics;
    }
    /**
     * Set VehicleGPRSDiagnostics value
     * @param \StructType\VehicleGPRSDiagnostics $vehicleGPRSDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleGPRSDiagnostics(\StructType\VehicleGPRSDiagnostics $vehicleGPRSDiagnostics = null)
    {
        $this->VehicleGPRSDiagnostics = $vehicleGPRSDiagnostics;
        return $this;
    }
    /**
     * Get VehicleHardwareDiagnostics value
     * @return \StructType\VehicleHardwareDiagnostics|null
     */
    public function getVehicleHardwareDiagnostics()
    {
        return $this->VehicleHardwareDiagnostics;
    }
    /**
     * Set VehicleHardwareDiagnostics value
     * @param \StructType\VehicleHardwareDiagnostics $vehicleHardwareDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleHardwareDiagnostics(\StructType\VehicleHardwareDiagnostics $vehicleHardwareDiagnostics = null)
    {
        $this->VehicleHardwareDiagnostics = $vehicleHardwareDiagnostics;
        return $this;
    }
    /**
     * Get VehicleIdentificationDiagnostics value
     * @return \StructType\VehicleIdentificationDiagnostics|null
     */
    public function getVehicleIdentificationDiagnostics()
    {
        return $this->VehicleIdentificationDiagnostics;
    }
    /**
     * Set VehicleIdentificationDiagnostics value
     * @param \StructType\VehicleIdentificationDiagnostics $vehicleIdentificationDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleIdentificationDiagnostics(\StructType\VehicleIdentificationDiagnostics $vehicleIdentificationDiagnostics = null)
    {
        $this->VehicleIdentificationDiagnostics = $vehicleIdentificationDiagnostics;
        return $this;
    }
    /**
     * Get VehicleMapDiagnostics value
     * @return \StructType\VehicleMapDiagnostics|null
     */
    public function getVehicleMapDiagnostics()
    {
        return $this->VehicleMapDiagnostics;
    }
    /**
     * Set VehicleMapDiagnostics value
     * @param \StructType\VehicleMapDiagnostics $vehicleMapDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleMapDiagnostics(\StructType\VehicleMapDiagnostics $vehicleMapDiagnostics = null)
    {
        $this->VehicleMapDiagnostics = $vehicleMapDiagnostics;
        return $this;
    }
    /**
     * Get VehiclePositionDiagnostics value
     * @return \StructType\VehiclePositionDiagnostics|null
     */
    public function getVehiclePositionDiagnostics()
    {
        return $this->VehiclePositionDiagnostics;
    }
    /**
     * Set VehiclePositionDiagnostics value
     * @param \StructType\VehiclePositionDiagnostics $vehiclePositionDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehiclePositionDiagnostics(\StructType\VehiclePositionDiagnostics $vehiclePositionDiagnostics = null)
    {
        $this->VehiclePositionDiagnostics = $vehiclePositionDiagnostics;
        return $this;
    }
    /**
     * Get VehicleTachoDiagnostics value
     * @return \StructType\VehicleTachoDiagnostics|null
     */
    public function getVehicleTachoDiagnostics()
    {
        return $this->VehicleTachoDiagnostics;
    }
    /**
     * Set VehicleTachoDiagnostics value
     * @param \StructType\VehicleTachoDiagnostics $vehicleTachoDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleTachoDiagnostics(\StructType\VehicleTachoDiagnostics $vehicleTachoDiagnostics = null)
    {
        $this->VehicleTachoDiagnostics = $vehicleTachoDiagnostics;
        return $this;
    }
    /**
     * Get VehicleTimeDiagnostics value
     * @return \StructType\VehicleTimeDiagnostics|null
     */
    public function getVehicleTimeDiagnostics()
    {
        return $this->VehicleTimeDiagnostics;
    }
    /**
     * Set VehicleTimeDiagnostics value
     * @param \StructType\VehicleTimeDiagnostics $vehicleTimeDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleTimeDiagnostics(\StructType\VehicleTimeDiagnostics $vehicleTimeDiagnostics = null)
    {
        $this->VehicleTimeDiagnostics = $vehicleTimeDiagnostics;
        return $this;
    }
    /**
     * Get VehicleStateDiagnostics value
     * @return \StructType\VehicleStateDiagnostics|null
     */
    public function getVehicleStateDiagnostics()
    {
        return $this->VehicleStateDiagnostics;
    }
    /**
     * Set VehicleStateDiagnostics value
     * @param \StructType\VehicleStateDiagnostics $vehicleStateDiagnostics
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setVehicleStateDiagnostics(\StructType\VehicleStateDiagnostics $vehicleStateDiagnostics = null)
    {
        $this->VehicleStateDiagnostics = $vehicleStateDiagnostics;
        return $this;
    }
    /**
     * Get LastTextMessageInbox value
     * @return \StructType\InterfaceTextMessageResult|null
     */
    public function getLastTextMessageInbox()
    {
        return $this->LastTextMessageInbox;
    }
    /**
     * Set LastTextMessageInbox value
     * @param \StructType\InterfaceTextMessageResult $lastTextMessageInbox
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setLastTextMessageInbox(\StructType\InterfaceTextMessageResult $lastTextMessageInbox = null)
    {
        $this->LastTextMessageInbox = $lastTextMessageInbox;
        return $this;
    }
    /**
     * Get LastTextMessageOutbox value
     * @return \StructType\InterfaceTextMessageResult|null
     */
    public function getLastTextMessageOutbox()
    {
        return $this->LastTextMessageOutbox;
    }
    /**
     * Set LastTextMessageOutbox value
     * @param \StructType\InterfaceTextMessageResult $lastTextMessageOutbox
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setLastTextMessageOutbox(\StructType\InterfaceTextMessageResult $lastTextMessageOutbox = null)
    {
        $this->LastTextMessageOutbox = $lastTextMessageOutbox;
        return $this;
    }
    /**
     * Get LastAlarmMessage value
     * @return \StructType\InterfaceAlarmMessageResult|null
     */
    public function getLastAlarmMessage()
    {
        return $this->LastAlarmMessage;
    }
    /**
     * Set LastAlarmMessage value
     * @param \StructType\InterfaceAlarmMessageResult $lastAlarmMessage
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setLastAlarmMessage(\StructType\InterfaceAlarmMessageResult $lastAlarmMessage = null)
    {
        $this->LastAlarmMessage = $lastAlarmMessage;
        return $this;
    }
    /**
     * Get BlockedVehicleInfo value
     * @return \StructType\InterfaceBlockedVehicleResult|null
     */
    public function getBlockedVehicleInfo()
    {
        return $this->BlockedVehicleInfo;
    }
    /**
     * Set BlockedVehicleInfo value
     * @param \StructType\InterfaceBlockedVehicleResult $blockedVehicleInfo
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setBlockedVehicleInfo(\StructType\InterfaceBlockedVehicleResult $blockedVehicleInfo = null)
    {
        $this->BlockedVehicleInfo = $blockedVehicleInfo;
        return $this;
    }
    /**
     * Get AutoFilter value
     * @return string|null
     */
    public function getAutoFilter()
    {
        return $this->AutoFilter;
    }
    /**
     * Set AutoFilter value
     * @param string $autoFilter
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setAutoFilter($autoFilter = null)
    {
        // validation for constraint: string
        if (!is_null($autoFilter) && !is_string($autoFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoFilter)), __LINE__);
        }
        $this->AutoFilter = $autoFilter;
        return $this;
    }
    /**
     * Get CompanyCardInfo value
     * @return \StructType\VehicleCompanyCard|null
     */
    public function getCompanyCardInfo()
    {
        return $this->CompanyCardInfo;
    }
    /**
     * Set CompanyCardInfo value
     * @param \StructType\VehicleCompanyCard $companyCardInfo
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public function setCompanyCardInfo(\StructType\VehicleCompanyCard $companyCardInfo = null)
    {
        $this->CompanyCardInfo = $companyCardInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InterfaceVehicleResult_V7
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
