<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfringementReportItem StructType
 * @subpackage Structs
 */
class InfringementReportItem extends AbstractStructBase
{
    /**
     * The SynchronizationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The InfringementReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InfringementReport
     */
    public $InfringementReport;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * Constructor method for InfringementReportItem
     * @uses InfringementReportItem::setSynchronizationDate()
     * @uses InfringementReportItem::setInfringementReport()
     * @uses InfringementReportItem::setDriver()
     * @param string $synchronizationDate
     * @param \StructType\InfringementReport $infringementReport
     * @param \StructType\IdentifierPerson $driver
     */
    public function __construct($synchronizationDate = null, \StructType\InfringementReport $infringementReport = null, \StructType\IdentifierPerson $driver = null)
    {
        $this
            ->setSynchronizationDate($synchronizationDate)
            ->setInfringementReport($infringementReport)
            ->setDriver($driver);
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\InfringementReportItem
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get InfringementReport value
     * @return \StructType\InfringementReport|null
     */
    public function getInfringementReport()
    {
        return $this->InfringementReport;
    }
    /**
     * Set InfringementReport value
     * @param \StructType\InfringementReport $infringementReport
     * @return \StructType\InfringementReportItem
     */
    public function setInfringementReport(\StructType\InfringementReport $infringementReport = null)
    {
        $this->InfringementReport = $infringementReport;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\InfringementReportItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfringementReportItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
