<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infringement StructType
 * @subpackage Structs
 */
class Infringement extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The InternalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternalCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ClassList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClassItem
     */
    public $ClassList;
    /**
     * The Standard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Standard;
    /**
     * Constructor method for Infringement
     * @uses Infringement::setCode()
     * @uses Infringement::setName()
     * @uses Infringement::setInternalCode()
     * @uses Infringement::setDescription()
     * @uses Infringement::setClassList()
     * @uses Infringement::setStandard()
     * @param string $code
     * @param string $name
     * @param string $internalCode
     * @param string $description
     * @param \ArrayType\ArrayOfClassItem $classList
     * @param string $standard
     */
    public function __construct($code = null, $name = null, $internalCode = null, $description = null, \ArrayType\ArrayOfClassItem $classList = null, $standard = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setInternalCode($internalCode)
            ->setDescription($description)
            ->setClassList($classList)
            ->setStandard($standard);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Infringement
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Infringement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get InternalCode value
     * @return string|null
     */
    public function getInternalCode()
    {
        return $this->InternalCode;
    }
    /**
     * Set InternalCode value
     * @param string $internalCode
     * @return \StructType\Infringement
     */
    public function setInternalCode($internalCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalCode) && !is_string($internalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalCode)), __LINE__);
        }
        $this->InternalCode = $internalCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Infringement
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ClassList value
     * @return \ArrayType\ArrayOfClassItem|null
     */
    public function getClassList()
    {
        return $this->ClassList;
    }
    /**
     * Set ClassList value
     * @param \ArrayType\ArrayOfClassItem $classList
     * @return \StructType\Infringement
     */
    public function setClassList(\ArrayType\ArrayOfClassItem $classList = null)
    {
        $this->ClassList = $classList;
        return $this;
    }
    /**
     * Get Standard value
     * @return string|null
     */
    public function getStandard()
    {
        return $this->Standard;
    }
    /**
     * Set Standard value
     * @param string $standard
     * @return \StructType\Infringement
     */
    public function setStandard($standard = null)
    {
        // validation for constraint: string
        if (!is_null($standard) && !is_string($standard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($standard)), __LINE__);
        }
        $this->Standard = $standard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Infringement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
