<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierPlace StructType
 * @subpackage Structs
 */
class IdentifierPlace extends AbstractStructBase
{
    /**
     * The IdentifierType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IdentifierPlace
     * @uses IdentifierPlace::setIdentifierType()
     * @uses IdentifierPlace::setId()
     * @param string $identifierType
     * @param string $id
     */
    public function __construct($identifierType = null, $id = null)
    {
        $this
            ->setIdentifierType($identifierType)
            ->setId($id);
    }
    /**
     * Get IdentifierType value
     * @return string
     */
    public function getIdentifierType()
    {
        return $this->IdentifierType;
    }
    /**
     * Set IdentifierType value
     * @uses \EnumType\EnumIdentifierPlace::valueIsValid()
     * @uses \EnumType\EnumIdentifierPlace::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierType
     * @return \StructType\IdentifierPlace
     */
    public function setIdentifierType($identifierType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumIdentifierPlace::valueIsValid($identifierType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $identifierType, implode(', ', \EnumType\EnumIdentifierPlace::getValidValues())), __LINE__);
        }
        $this->IdentifierType = $identifierType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IdentifierPlace
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentifierPlace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
