<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierFile StructType
 * @subpackage Structs
 */
class IdentifierFile extends AbstractStructBase
{
    /**
     * The IdentifierFileType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierFileType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IdentifierFile
     * @uses IdentifierFile::setIdentifierFileType()
     * @uses IdentifierFile::setId()
     * @param string $identifierFileType
     * @param string $id
     */
    public function __construct($identifierFileType = null, $id = null)
    {
        $this
            ->setIdentifierFileType($identifierFileType)
            ->setId($id);
    }
    /**
     * Get IdentifierFileType value
     * @return string
     */
    public function getIdentifierFileType()
    {
        return $this->IdentifierFileType;
    }
    /**
     * Set IdentifierFileType value
     * @uses \EnumType\EnumIdentifierFileType::valueIsValid()
     * @uses \EnumType\EnumIdentifierFileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierFileType
     * @return \StructType\IdentifierFile
     */
    public function setIdentifierFileType($identifierFileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumIdentifierFileType::valueIsValid($identifierFileType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $identifierFileType, implode(', ', \EnumType\EnumIdentifierFileType::getValidValues())), __LINE__);
        }
        $this->IdentifierFileType = $identifierFileType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IdentifierFile
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentifierFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
