<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IDRangeSelection StructType
 * @subpackage Structs
 */
class IDRangeSelection extends AbstractStructBase
{
    /**
     * The SinceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SinceID;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Amount;
    /**
     * Constructor method for IDRangeSelection
     * @uses IDRangeSelection::setSinceID()
     * @uses IDRangeSelection::setAmount()
     * @param int $sinceID
     * @param int $amount
     */
    public function __construct($sinceID = null, $amount = null)
    {
        $this
            ->setSinceID($sinceID)
            ->setAmount($amount);
    }
    /**
     * Get SinceID value
     * @return int
     */
    public function getSinceID()
    {
        return $this->SinceID;
    }
    /**
     * Set SinceID value
     * @param int $sinceID
     * @return \StructType\IDRangeSelection
     */
    public function setSinceID($sinceID = null)
    {
        // validation for constraint: int
        if (!is_null($sinceID) && !is_numeric($sinceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sinceID)), __LINE__);
        }
        $this->SinceID = $sinceID;
        return $this;
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\IDRangeSelection
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !is_numeric($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IDRangeSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
