<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVehicleActivityInfoResult_V2 StructType
 * @subpackage Structs
 */
class GetVehicleActivityInfoResult_V2 extends ExecutionResult
{
    /**
     * The MaximumModificationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaximumModificationDate;
    /**
     * The MaximumModificationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The VehicleActivityInfoItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfVehicleActivityInfoItem_V2
     */
    public $VehicleActivityInfoItems;
    /**
     * Constructor method for GetVehicleActivityInfoResult_V2
     * @uses GetVehicleActivityInfoResult_V2::setMaximumModificationDate()
     * @uses GetVehicleActivityInfoResult_V2::setMaximumModificationID()
     * @uses GetVehicleActivityInfoResult_V2::setVehicleActivityInfoItems()
     * @param string $maximumModificationDate
     * @param int $maximumModificationID
     * @param \ArrayType\ArrayOfVehicleActivityInfoItem_V2 $vehicleActivityInfoItems
     */
    public function __construct($maximumModificationDate = null, $maximumModificationID = null, \ArrayType\ArrayOfVehicleActivityInfoItem_V2 $vehicleActivityInfoItems = null)
    {
        $this
            ->setMaximumModificationDate($maximumModificationDate)
            ->setMaximumModificationID($maximumModificationID)
            ->setVehicleActivityInfoItems($vehicleActivityInfoItems);
    }
    /**
     * Get MaximumModificationDate value
     * @return string
     */
    public function getMaximumModificationDate()
    {
        return $this->MaximumModificationDate;
    }
    /**
     * Set MaximumModificationDate value
     * @param string $maximumModificationDate
     * @return \StructType\GetVehicleActivityInfoResult_V2
     */
    public function setMaximumModificationDate($maximumModificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($maximumModificationDate) && !is_string($maximumModificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumModificationDate)), __LINE__);
        }
        $this->MaximumModificationDate = $maximumModificationDate;
        return $this;
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetVehicleActivityInfoResult_V2
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !is_numeric($maximumModificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get VehicleActivityInfoItems value
     * @return \ArrayType\ArrayOfVehicleActivityInfoItem_V2|null
     */
    public function getVehicleActivityInfoItems()
    {
        return $this->VehicleActivityInfoItems;
    }
    /**
     * Set VehicleActivityInfoItems value
     * @param \ArrayType\ArrayOfVehicleActivityInfoItem_V2 $vehicleActivityInfoItems
     * @return \StructType\GetVehicleActivityInfoResult_V2
     */
    public function setVehicleActivityInfoItems(\ArrayType\ArrayOfVehicleActivityInfoItem_V2 $vehicleActivityInfoItems = null)
    {
        $this->VehicleActivityInfoItems = $vehicleActivityInfoItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVehicleActivityInfoResult_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
