<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPlanningHistoricalSelectionResult StructType
 * @subpackage Structs
 */
class GetPlanningHistoricalSelectionResult extends AbstractStructBase
{
    /**
     * The Plannings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlanningResult
     */
    public $Plannings;
    /**
     * The Anomalies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnomaly
     */
    public $Anomalies;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommentHistoricalResult
     */
    public $Comments;
    /**
     * Constructor method for GetPlanningHistoricalSelectionResult
     * @uses GetPlanningHistoricalSelectionResult::setPlannings()
     * @uses GetPlanningHistoricalSelectionResult::setAnomalies()
     * @uses GetPlanningHistoricalSelectionResult::setComments()
     * @param \ArrayType\ArrayOfPlanningResult $plannings
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @param \ArrayType\ArrayOfCommentHistoricalResult $comments
     */
    public function __construct(\ArrayType\ArrayOfPlanningResult $plannings = null, \ArrayType\ArrayOfAnomaly $anomalies = null, \ArrayType\ArrayOfCommentHistoricalResult $comments = null)
    {
        $this
            ->setPlannings($plannings)
            ->setAnomalies($anomalies)
            ->setComments($comments);
    }
    /**
     * Get Plannings value
     * @return \ArrayType\ArrayOfPlanningResult|null
     */
    public function getPlannings()
    {
        return $this->Plannings;
    }
    /**
     * Set Plannings value
     * @param \ArrayType\ArrayOfPlanningResult $plannings
     * @return \StructType\GetPlanningHistoricalSelectionResult
     */
    public function setPlannings(\ArrayType\ArrayOfPlanningResult $plannings = null)
    {
        $this->Plannings = $plannings;
        return $this;
    }
    /**
     * Get Anomalies value
     * @return \ArrayType\ArrayOfAnomaly|null
     */
    public function getAnomalies()
    {
        return $this->Anomalies;
    }
    /**
     * Set Anomalies value
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @return \StructType\GetPlanningHistoricalSelectionResult
     */
    public function setAnomalies(\ArrayType\ArrayOfAnomaly $anomalies = null)
    {
        $this->Anomalies = $anomalies;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfCommentHistoricalResult|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfCommentHistoricalResult $comments
     * @return \StructType\GetPlanningHistoricalSelectionResult
     */
    public function setComments(\ArrayType\ArrayOfCommentHistoricalResult $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPlanningHistoricalSelectionResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
