<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMapSelection_V2 StructType
 * @subpackage Structs
 */
class GetMapSelection_V2 extends AbstractStructBase
{
    /**
     * The Zoom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Zoom;
    /**
     * The Size
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Size
     */
    public $Size;
    /**
     * The IncludeInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeInformation;
    /**
     * The IncludeAddressInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeAddressInformation;
    /**
     * The IncludeViaRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeViaRoute;
    /**
     * The IncludeDrivenRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeDrivenRoute;
    /**
     * The IncludeRouteInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeRouteInformation;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicle
     */
    public $Trailers;
    /**
     * The ViaRoutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierViaRoute
     */
    public $ViaRoutes;
    /**
     * The DateTimeRangeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * Constructor method for GetMapSelection_V2
     * @uses GetMapSelection_V2::setZoom()
     * @uses GetMapSelection_V2::setSize()
     * @uses GetMapSelection_V2::setIncludeInformation()
     * @uses GetMapSelection_V2::setIncludeAddressInformation()
     * @uses GetMapSelection_V2::setIncludeViaRoute()
     * @uses GetMapSelection_V2::setIncludeDrivenRoute()
     * @uses GetMapSelection_V2::setIncludeRouteInformation()
     * @uses GetMapSelection_V2::setDrivers()
     * @uses GetMapSelection_V2::setVehicles()
     * @uses GetMapSelection_V2::setTrailers()
     * @uses GetMapSelection_V2::setViaRoutes()
     * @uses GetMapSelection_V2::setDateTimeRangeSelection()
     * @param float $zoom
     * @param \StructType\Size $size
     * @param bool $includeInformation
     * @param bool $includeAddressInformation
     * @param bool $includeViaRoute
     * @param bool $includeDrivenRoute
     * @param bool $includeRouteInformation
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @param \ArrayType\ArrayOfIdentifierViaRoute $viaRoutes
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     */
    public function __construct($zoom = null, \StructType\Size $size = null, $includeInformation = null, $includeAddressInformation = null, $includeViaRoute = null, $includeDrivenRoute = null, $includeRouteInformation = null, \ArrayType\ArrayOfIdentifier $drivers = null, \ArrayType\ArrayOfIdentifierVehicle $vehicles = null, \ArrayType\ArrayOfIdentifierVehicle $trailers = null, \ArrayType\ArrayOfIdentifierViaRoute $viaRoutes = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this
            ->setZoom($zoom)
            ->setSize($size)
            ->setIncludeInformation($includeInformation)
            ->setIncludeAddressInformation($includeAddressInformation)
            ->setIncludeViaRoute($includeViaRoute)
            ->setIncludeDrivenRoute($includeDrivenRoute)
            ->setIncludeRouteInformation($includeRouteInformation)
            ->setDrivers($drivers)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setViaRoutes($viaRoutes)
            ->setDateTimeRangeSelection($dateTimeRangeSelection);
    }
    /**
     * Get Zoom value
     * @return float
     */
    public function getZoom()
    {
        return $this->Zoom;
    }
    /**
     * Set Zoom value
     * @param float $zoom
     * @return \StructType\GetMapSelection_V2
     */
    public function setZoom($zoom = null)
    {
        $this->Zoom = $zoom;
        return $this;
    }
    /**
     * Get Size value
     * @return \StructType\Size
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param \StructType\Size $size
     * @return \StructType\GetMapSelection_V2
     */
    public function setSize(\StructType\Size $size = null)
    {
        $this->Size = $size;
        return $this;
    }
    /**
     * Get IncludeInformation value
     * @return bool
     */
    public function getIncludeInformation()
    {
        return $this->IncludeInformation;
    }
    /**
     * Set IncludeInformation value
     * @param bool $includeInformation
     * @return \StructType\GetMapSelection_V2
     */
    public function setIncludeInformation($includeInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInformation) && !is_bool($includeInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeInformation)), __LINE__);
        }
        $this->IncludeInformation = $includeInformation;
        return $this;
    }
    /**
     * Get IncludeAddressInformation value
     * @return bool
     */
    public function getIncludeAddressInformation()
    {
        return $this->IncludeAddressInformation;
    }
    /**
     * Set IncludeAddressInformation value
     * @param bool $includeAddressInformation
     * @return \StructType\GetMapSelection_V2
     */
    public function setIncludeAddressInformation($includeAddressInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAddressInformation) && !is_bool($includeAddressInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeAddressInformation)), __LINE__);
        }
        $this->IncludeAddressInformation = $includeAddressInformation;
        return $this;
    }
    /**
     * Get IncludeViaRoute value
     * @return bool
     */
    public function getIncludeViaRoute()
    {
        return $this->IncludeViaRoute;
    }
    /**
     * Set IncludeViaRoute value
     * @param bool $includeViaRoute
     * @return \StructType\GetMapSelection_V2
     */
    public function setIncludeViaRoute($includeViaRoute = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeViaRoute) && !is_bool($includeViaRoute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeViaRoute)), __LINE__);
        }
        $this->IncludeViaRoute = $includeViaRoute;
        return $this;
    }
    /**
     * Get IncludeDrivenRoute value
     * @return bool
     */
    public function getIncludeDrivenRoute()
    {
        return $this->IncludeDrivenRoute;
    }
    /**
     * Set IncludeDrivenRoute value
     * @param bool $includeDrivenRoute
     * @return \StructType\GetMapSelection_V2
     */
    public function setIncludeDrivenRoute($includeDrivenRoute = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDrivenRoute) && !is_bool($includeDrivenRoute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeDrivenRoute)), __LINE__);
        }
        $this->IncludeDrivenRoute = $includeDrivenRoute;
        return $this;
    }
    /**
     * Get IncludeRouteInformation value
     * @return bool
     */
    public function getIncludeRouteInformation()
    {
        return $this->IncludeRouteInformation;
    }
    /**
     * Set IncludeRouteInformation value
     * @param bool $includeRouteInformation
     * @return \StructType\GetMapSelection_V2
     */
    public function setIncludeRouteInformation($includeRouteInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRouteInformation) && !is_bool($includeRouteInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeRouteInformation)), __LINE__);
        }
        $this->IncludeRouteInformation = $includeRouteInformation;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\GetMapSelection_V2
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicle $vehicles
     * @return \StructType\GetMapSelection_V2
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicle $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicle|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicle $trailers
     * @return \StructType\GetMapSelection_V2
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicle $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get ViaRoutes value
     * @return \ArrayType\ArrayOfIdentifierViaRoute|null
     */
    public function getViaRoutes()
    {
        return $this->ViaRoutes;
    }
    /**
     * Set ViaRoutes value
     * @param \ArrayType\ArrayOfIdentifierViaRoute $viaRoutes
     * @return \StructType\GetMapSelection_V2
     */
    public function setViaRoutes(\ArrayType\ArrayOfIdentifierViaRoute $viaRoutes = null)
    {
        $this->ViaRoutes = $viaRoutes;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\GetMapSelection_V2
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMapSelection_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
