<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetActivityReportResult_V11 StructType
 * @subpackage Structs
 */
class GetActivityReportResult_V11 extends ExecutionResult
{
    /**
     * The MaximumModificationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The MaximumModificationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaximumModificationDate;
    /**
     * The IsMoreDataPresent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsMoreDataPresent;
    /**
     * The ActivityReportItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityReportItem_V11
     */
    public $ActivityReportItems;
    /**
     * Constructor method for GetActivityReportResult_V11
     * @uses GetActivityReportResult_V11::setMaximumModificationID()
     * @uses GetActivityReportResult_V11::setMaximumModificationDate()
     * @uses GetActivityReportResult_V11::setIsMoreDataPresent()
     * @uses GetActivityReportResult_V11::setActivityReportItems()
     * @param int $maximumModificationID
     * @param string $maximumModificationDate
     * @param bool $isMoreDataPresent
     * @param \ArrayType\ArrayOfActivityReportItem_V11 $activityReportItems
     */
    public function __construct($maximumModificationID = null, $maximumModificationDate = null, $isMoreDataPresent = null, \ArrayType\ArrayOfActivityReportItem_V11 $activityReportItems = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setMaximumModificationDate($maximumModificationDate)
            ->setIsMoreDataPresent($isMoreDataPresent)
            ->setActivityReportItems($activityReportItems);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetActivityReportResult_V11
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !is_numeric($maximumModificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get MaximumModificationDate value
     * @return string
     */
    public function getMaximumModificationDate()
    {
        return $this->MaximumModificationDate;
    }
    /**
     * Set MaximumModificationDate value
     * @param string $maximumModificationDate
     * @return \StructType\GetActivityReportResult_V11
     */
    public function setMaximumModificationDate($maximumModificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($maximumModificationDate) && !is_string($maximumModificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumModificationDate)), __LINE__);
        }
        $this->MaximumModificationDate = $maximumModificationDate;
        return $this;
    }
    /**
     * Get IsMoreDataPresent value
     * @return bool
     */
    public function getIsMoreDataPresent()
    {
        return $this->IsMoreDataPresent;
    }
    /**
     * Set IsMoreDataPresent value
     * @param bool $isMoreDataPresent
     * @return \StructType\GetActivityReportResult_V11
     */
    public function setIsMoreDataPresent($isMoreDataPresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMoreDataPresent) && !is_bool($isMoreDataPresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMoreDataPresent)), __LINE__);
        }
        $this->IsMoreDataPresent = $isMoreDataPresent;
        return $this;
    }
    /**
     * Get ActivityReportItems value
     * @return \ArrayType\ArrayOfActivityReportItem_V11|null
     */
    public function getActivityReportItems()
    {
        return $this->ActivityReportItems;
    }
    /**
     * Set ActivityReportItems value
     * @param \ArrayType\ArrayOfActivityReportItem_V11 $activityReportItems
     * @return \StructType\GetActivityReportResult_V11
     */
    public function setActivityReportItems(\ArrayType\ArrayOfActivityReportItem_V11 $activityReportItems = null)
    {
        $this->ActivityReportItems = $activityReportItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetActivityReportResult_V11
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
