<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetActivityReportResult_V10 StructType
 * @subpackage Structs
 */
class GetActivityReportResult_V10 extends ExecutionResult
{
    /**
     * The MaximumModificationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The ActivityReportItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityReportItem_V10
     */
    public $ActivityReportItems;
    /**
     * Constructor method for GetActivityReportResult_V10
     * @uses GetActivityReportResult_V10::setMaximumModificationID()
     * @uses GetActivityReportResult_V10::setActivityReportItems()
     * @param int $maximumModificationID
     * @param \ArrayType\ArrayOfActivityReportItem_V10 $activityReportItems
     */
    public function __construct($maximumModificationID = null, \ArrayType\ArrayOfActivityReportItem_V10 $activityReportItems = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setActivityReportItems($activityReportItems);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetActivityReportResult_V10
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !is_numeric($maximumModificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get ActivityReportItems value
     * @return \ArrayType\ArrayOfActivityReportItem_V10|null
     */
    public function getActivityReportItems()
    {
        return $this->ActivityReportItems;
    }
    /**
     * Set ActivityReportItems value
     * @param \ArrayType\ArrayOfActivityReportItem_V10 $activityReportItems
     * @return \StructType\GetActivityReportResult_V10
     */
    public function setActivityReportItems(\ArrayType\ArrayOfActivityReportItem_V10 $activityReportItems = null)
    {
        $this->ActivityReportItems = $activityReportItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetActivityReportResult_V10
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
