<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetActivityReportDetailResult_V8 StructType
 * @subpackage Structs
 */
class GetActivityReportDetailResult_V8 extends ExecutionResult
{
    /**
     * The MaximumModificationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumModificationID;
    /**
     * The ActivityReportDetailItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityReportDetailItem_V8
     */
    public $ActivityReportDetailItems;
    /**
     * Constructor method for GetActivityReportDetailResult_V8
     * @uses GetActivityReportDetailResult_V8::setMaximumModificationID()
     * @uses GetActivityReportDetailResult_V8::setActivityReportDetailItems()
     * @param int $maximumModificationID
     * @param \ArrayType\ArrayOfActivityReportDetailItem_V8 $activityReportDetailItems
     */
    public function __construct($maximumModificationID = null, \ArrayType\ArrayOfActivityReportDetailItem_V8 $activityReportDetailItems = null)
    {
        $this
            ->setMaximumModificationID($maximumModificationID)
            ->setActivityReportDetailItems($activityReportDetailItems);
    }
    /**
     * Get MaximumModificationID value
     * @return int
     */
    public function getMaximumModificationID()
    {
        return $this->MaximumModificationID;
    }
    /**
     * Set MaximumModificationID value
     * @param int $maximumModificationID
     * @return \StructType\GetActivityReportDetailResult_V8
     */
    public function setMaximumModificationID($maximumModificationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumModificationID) && !is_numeric($maximumModificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumModificationID)), __LINE__);
        }
        $this->MaximumModificationID = $maximumModificationID;
        return $this;
    }
    /**
     * Get ActivityReportDetailItems value
     * @return \ArrayType\ArrayOfActivityReportDetailItem_V8|null
     */
    public function getActivityReportDetailItems()
    {
        return $this->ActivityReportDetailItems;
    }
    /**
     * Set ActivityReportDetailItems value
     * @param \ArrayType\ArrayOfActivityReportDetailItem_V8 $activityReportDetailItems
     * @return \StructType\GetActivityReportDetailResult_V8
     */
    public function setActivityReportDetailItems(\ArrayType\ArrayOfActivityReportDetailItem_V8 $activityReportDetailItems = null)
    {
        $this->ActivityReportDetailItems = $activityReportDetailItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetActivityReportDetailResult_V8
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
