<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoZone StructType
 * @subpackage Structs
 */
class GeoZone extends AbstractStructBase
{
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Radius;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The DriverAlarmText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverAlarmText;
    /**
     * Constructor method for GeoZone
     * @uses GeoZone::setRadius()
     * @uses GeoZone::setName()
     * @uses GeoZone::setPosition()
     * @uses GeoZone::setDriverAlarmText()
     * @param int $radius
     * @param string $name
     * @param \StructType\Position $position
     * @param string $driverAlarmText
     */
    public function __construct($radius = null, $name = null, \StructType\Position $position = null, $driverAlarmText = null)
    {
        $this
            ->setRadius($radius)
            ->setName($name)
            ->setPosition($position)
            ->setDriverAlarmText($driverAlarmText);
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\GeoZone
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !is_numeric($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\GeoZone
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\GeoZone
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get DriverAlarmText value
     * @return string|null
     */
    public function getDriverAlarmText()
    {
        return $this->DriverAlarmText;
    }
    /**
     * Set DriverAlarmText value
     * @param string $driverAlarmText
     * @return \StructType\GeoZone
     */
    public function setDriverAlarmText($driverAlarmText = null)
    {
        // validation for constraint: string
        if (!is_null($driverAlarmText) && !is_string($driverAlarmText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverAlarmText)), __LINE__);
        }
        $this->DriverAlarmText = $driverAlarmText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeoZone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
