<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoFenceUpdate StructType
 * @subpackage Structs
 */
class GeoFenceUpdate extends GeoFenceInsert
{
    /**
     * The GeoZoneUpdateType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GeoZoneUpdateType;
    /**
     * The GeoFence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierGeoFence
     */
    public $GeoFence;
    /**
     * Constructor method for GeoFenceUpdate
     * @uses GeoFenceUpdate::setGeoZoneUpdateType()
     * @uses GeoFenceUpdate::setGeoFence()
     * @param string $geoZoneUpdateType
     * @param \StructType\IdentifierGeoFence $geoFence
     */
    public function __construct($geoZoneUpdateType = null, \StructType\IdentifierGeoFence $geoFence = null)
    {
        $this
            ->setGeoZoneUpdateType($geoZoneUpdateType)
            ->setGeoFence($geoFence);
    }
    /**
     * Get GeoZoneUpdateType value
     * @return string
     */
    public function getGeoZoneUpdateType()
    {
        return $this->GeoZoneUpdateType;
    }
    /**
     * Set GeoZoneUpdateType value
     * @uses \EnumType\EnumGeoZoneUpdateType::valueIsValid()
     * @uses \EnumType\EnumGeoZoneUpdateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoZoneUpdateType
     * @return \StructType\GeoFenceUpdate
     */
    public function setGeoZoneUpdateType($geoZoneUpdateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoZoneUpdateType::valueIsValid($geoZoneUpdateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoZoneUpdateType, implode(', ', \EnumType\EnumGeoZoneUpdateType::getValidValues())), __LINE__);
        }
        $this->GeoZoneUpdateType = $geoZoneUpdateType;
        return $this;
    }
    /**
     * Get GeoFence value
     * @return \StructType\IdentifierGeoFence|null
     */
    public function getGeoFence()
    {
        return $this->GeoFence;
    }
    /**
     * Set GeoFence value
     * @param \StructType\IdentifierGeoFence $geoFence
     * @return \StructType\GeoFenceUpdate
     */
    public function setGeoFence(\StructType\IdentifierGeoFence $geoFence = null)
    {
        $this->GeoFence = $geoFence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeoFenceUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
